/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.client.api;

import com.alibaba.fastjson.JSON;
import com.bizvane.base.common.bean.ErrorInfo;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.dto.ChannelDto;
import com.bizvane.base.remote.dto.MerchantDto;
import com.bizvane.message.cache.entity.MerchantCache;
import com.bizvane.message.component.bean.BizvaneExceptionEnum;
import com.bizvane.message.component.bean.MessageException;
import com.bizvane.message.component.bean.MessageStrategyEnum;
import com.bizvane.message.entity.Channel;
import com.bizvane.message.entity.Merchant;
import com.bizvane.message.service.inter.IChannelService;
import com.bizvane.message.service.inter.IMerchantService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RemoteMerchantService {
    private static final Logger log = LoggerFactory.getLogger(RemoteMerchantService.class);
    @Autowired
    private IMerchantService merchantService;
    @Autowired
    private IChannelService channelService;

    public ResultBean<MerchantDto> saveMerchant(String companyName, String brandName, String notifyUrl) {
        log.info("\u521b\u5efa\u5546\u6237,\u5165\u53c2:companyName:{},brandName:{},notifyUrl:{}", new Object[]{companyName, brandName, notifyUrl});
        ResultBean resultBean = new ResultBean();
        try {
            if (StringUtils.isBlank((CharSequence)notifyUrl)) {
                resultBean.setSuccess(Boolean.valueOf(false));
                resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_REQUEST_NOTIFY_URL_NOT_EXIST.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_REQUEST_NOTIFY_URL_NOT_EXIST.getErrCodeDes()));
                return resultBean;
            }
            Merchant merchant = this.merchantService.saveMerchant(companyName, brandName, notifyUrl);
            MerchantDto merchantDto = new MerchantDto();
            BeanUtils.copyProperties((Object)merchant, (Object)merchantDto);
            resultBean.setResult((Object)merchantDto);
            resultBean.setSuccess(Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5546\u6237\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCodeDes()));
        }
        log.info("\u521b\u5efa\u5546\u6237\u5b8c\u6210,\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)resultBean));
        return resultBean;
    }

    public ResultBean<MerchantDto> updateMerchant(String merchantId, String companyName, String brandName, String notifyUrl) {
        log.info("\u66f4\u65b0\u5546\u6237\u4fe1\u606f,\u5165\u53c2:merchantId:{},companyName:{},brandName:{}", new Object[]{merchantId, companyName, brandName});
        ResultBean resultBean = new ResultBean();
        resultBean.setSuccess(Boolean.valueOf(false));
        try {
            if (StringUtils.isBlank((CharSequence)merchantId)) {
                resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_REQUEST_MERCHANT_ID_NOT_EXIST.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_REQUEST_MERCHANT_ID_NOT_EXIST.getErrCodeDes()));
                return resultBean;
            }
            MerchantCache merchantCache = this.merchantService.getMerchant(merchantId);
            if (merchantCache == null) {
                resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.NOT_EXIST_ERROR.getErrCode(), BizvaneExceptionEnum.NOT_EXIST_ERROR.getErrCodeDes()));
                return resultBean;
            }
            Merchant merchant = this.merchantService.updateMerchant(merchantId, companyName, brandName, notifyUrl);
            MerchantDto merchantDto = new MerchantDto();
            BeanUtils.copyProperties((Object)merchant, (Object)merchantDto);
            resultBean.setSuccess(Boolean.TRUE);
            resultBean.setResult((Object)merchantDto);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCodeDes()));
        }
        log.info("\u66f4\u65b0\u5546\u6237\u5b8c\u6210,\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)resultBean));
        return resultBean;
    }

    public ResultBean<MerchantDto> getMerchant(String merchantId) {
        log.info("\u67e5\u8be2\u5546\u6237\u4fe1\u606f:\u5165\u53c2:{}", (Object)merchantId);
        ResultBean resultBean = new ResultBean();
        try {
            if (StringUtils.isBlank((CharSequence)merchantId)) {
                resultBean.setSuccess(Boolean.valueOf(false));
                resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_REQUEST_MERCHANT_ID_NOT_EXIST.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_REQUEST_MERCHANT_ID_NOT_EXIST.getErrCodeDes()));
                return resultBean;
            }
            MerchantCache merchant = this.merchantService.getMerchant(merchantId);
            if (merchant != null) {
                MerchantDto merchantDto = new MerchantDto();
                BeanUtils.copyProperties((Object)merchant, (Object)merchantDto);
                resultBean.setResult((Object)merchantDto);
            }
            resultBean.setSuccess(Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5546\u6237\u4fe1\u606f\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCodeDes()));
        }
        log.info("\u67e5\u8be2\u5546\u6237\u5b8c\u6210:{}", (Object)JSON.toJSONString((Object)resultBean));
        return resultBean;
    }

    public ResultBean deleteMerchant(String merchantId) {
        log.info("\u5220\u9664\u5546\u6237\u4fe1\u606f,\u5165\u53c2:{}", (Object)merchantId);
        ResultBean resultBean = new ResultBean();
        resultBean.setSuccess(Boolean.FALSE);
        MerchantCache merchant = this.merchantService.getMerchant(merchantId);
        if (merchant == null) {
            resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.NOT_EXIST_ERROR.getErrCode(), BizvaneExceptionEnum.NOT_EXIST_ERROR.getErrCodeDes()));
            return resultBean;
        }
        try {
            int count = this.merchantService.deleteMerchant(merchantId);
            if (count > 0) {
                resultBean.setSuccess(Boolean.TRUE);
            } else {
                resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.NOT_EXIST_ERROR.getErrCode(), BizvaneExceptionEnum.NOT_EXIST_ERROR.getErrCodeDes()));
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u5546\u6237\u4fe1\u606f\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCodeDes()));
        }
        log.info("\u5220\u9664\u5546\u6237\u5b8c\u6210:{}", (Object)JSON.toJSONString((Object)resultBean));
        return resultBean;
    }

    public ResultBean<ChannelDto> saveChannel(String merchantId, String channelName, String channelType, String accountJson) {
        log.info("\u4fdd\u5b58\u6e20\u9053\u4fe1\u606f,\u5165\u53c2:merchantId:{},channelName:{},channelType:{},accountJson:{}", new Object[]{merchantId, channelName, channelType, accountJson});
        ResultBean resultBean = new ResultBean();
        resultBean.setSuccess(Boolean.valueOf(false));
        MerchantCache merchant = this.merchantService.getMerchant(merchantId);
        if (merchant == null) {
            resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.NOT_EXIST_ERROR.getErrCode(), BizvaneExceptionEnum.NOT_EXIST_ERROR.getErrCodeDes()));
            return resultBean;
        }
        try {
            if (StringUtils.isEmpty((CharSequence)MessageStrategyEnum.getStrategyByType((String)channelType))) {
                resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.CHANNEL_TYPE_ERROR.getErrCode(), BizvaneExceptionEnum.CHANNEL_TYPE_ERROR.getErrCodeDes()));
                return resultBean;
            }
            Channel channel = this.channelService.saveChannel(merchantId, channelName, channelType, accountJson);
            ChannelDto channelDto = new ChannelDto();
            BeanUtils.copyProperties((Object)channel, (Object)channelDto);
            resultBean.setSuccess(Boolean.TRUE);
            resultBean.setResult((Object)channelDto);
        }
        catch (BeansException e) {
            log.error("\u4fdd\u5b58\u6e20\u9053\u4fe1\u606f\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCodeDes()));
        }
        log.info("\u4fdd\u5b58\u6e20\u9053\u5b8c\u6210:{}", (Object)JSON.toJSONString((Object)resultBean));
        return resultBean;
    }

    public ResultBean<ChannelDto> updateChannel(String merchantId, String channelName, String channelType, String accountJson) {
        log.info("\u66f4\u65b0\u6e20\u9053\u4fe1\u606f,\u5165\u53c2:merchantId:{},channelName:{},channelType:{},accountJson:{}", new Object[]{merchantId, channelName, channelType, accountJson});
        ResultBean resultBean = new ResultBean();
        resultBean.setSuccess(Boolean.valueOf(false));
        MerchantCache merchant = this.merchantService.getMerchant(merchantId);
        if (merchant == null) {
            resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.NOT_EXIST_ERROR.getErrCode(), BizvaneExceptionEnum.NOT_EXIST_ERROR.getErrCodeDes()));
            return resultBean;
        }
        try {
            if (StringUtils.isEmpty((CharSequence)MessageStrategyEnum.getStrategyByType((String)channelType))) {
                resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.CHANNEL_TYPE_ERROR.getErrCode(), BizvaneExceptionEnum.CHANNEL_TYPE_ERROR.getErrCodeDes()));
                return resultBean;
            }
            Channel channel = this.channelService.updateChannelOnlyPassnameAndPwd(merchantId, channelName, channelType, accountJson);
            ChannelDto channelDto = new ChannelDto();
            BeanUtils.copyProperties((Object)channel, (Object)channelDto);
            resultBean.setSuccess(Boolean.TRUE);
            resultBean.setResult((Object)channelDto);
        }
        catch (MessageException e) {
            log.error("\u66f4\u65b0\u6e20\u9053\u4fe1\u606f\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            resultBean.setErrorInfo(new ErrorInfo(e.getErrCode(), e.getErrCodeDes()));
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6e20\u9053\u4fe1\u606f\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCodeDes()));
        }
        log.info("\u4fdd\u5b58\u6e20\u9053\u5b8c\u6210:{}", (Object)JSON.toJSONString((Object)resultBean));
        return resultBean;
    }

    public ResultBean<ArrayList<ChannelDto>> findByMerchantId(String merchantId) {
        ResultBean result = new ResultBean();
        result.setSuccess(Boolean.valueOf(true));
        log.info("\u6279\u91cf\u67e5\u8be2\u6e20\u9053\u4fe1\u606f\uff0c\u5165\u53c2:merchantId{}", (Object)merchantId);
        List list = this.channelService.findByMerchantId(merchantId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return result;
        }
        ArrayList collect = list.stream().map(e -> {
            ChannelDto channelDto = new ChannelDto();
            BeanUtils.copyProperties((Object)e, (Object)channelDto);
            return channelDto;
        }).collect(Collectors.toCollection(ArrayList::new));
        result.setResult((Object)collect);
        return result;
    }
}

