/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.component;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bizvane.base.common.bean.SmsResBean;
import com.bizvane.message.cache.entity.ChannelConfigCache;
import com.bizvane.message.component.BaseComponent;
import com.bizvane.message.component.BatchOperationMessage;
import com.bizvane.message.component.MessageAccount;
import com.bizvane.message.component.bean.BizvaneExceptionEnum;
import com.bizvane.message.component.bean.GuoduMessage;
import com.bizvane.message.component.bean.GuoduSmsSendResponse;
import com.bizvane.message.component.bean.MessageException;
import com.bizvane.message.component.bean.SignatureBean;
import com.bizvane.message.component.bean.TemplateBean;
import com.bizvane.message.dao.TemplateDao;
import com.bizvane.message.entity.Template;
import com.bizvane.message.utils.GuoduSmsUtil;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="GUODU_STRATEGY")
public class GuoduSmsComponent
extends BaseComponent {
    private static final Logger log = LoggerFactory.getLogger(GuoduSmsComponent.class);
    @Autowired
    private TemplateDao templateDao;

    public TemplateBean callUpdateTemplate(ChannelConfigCache channelConfig, String templateName, String content, String templateType, String remark, String templateCode, String sign, String postFix) {
        return null;
    }

    @Deprecated
    public TemplateBean callDeleteTemplate(ChannelConfigCache channelConfig, String templateCode) {
        return null;
    }

    public TemplateBean callCreateTemplate(ChannelConfigCache channelConfig, String templateName, String templateType, String content, String remark, String sign, String postFix) {
        TemplateBean templateBean = TemplateBean.builder().templateCode("gateway_" + UUID.randomUUID().toString().split("-")[0]).templateName(templateName).status("1").remark(remark).createTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")).auditReason("\u77ed\u4fe1\u7f51\u5173\u901a\u8fc7").templateType(templateType).signature(sign).content(content).build();
        log.info("\u56fd\u90fd\u521b\u5efa\u6a21\u677f\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)templateBean));
        return templateBean;
    }

    public TemplateBean callQueryTemplate(ChannelConfigCache channelConfig, String templateCode) {
        Template template = this.templateDao.getByTemplateId(templateCode);
        return TemplateBean.builder().templateCode(template.getTemplateId()).templateName(template.getTemplateName()).status(template.getStatus() == null ? "" : template.getStatus() + "").remark(template.getRemark()).createTime(DateUtil.format((Date)template.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss")).auditReason("\u77ed\u4fe1\u7f51\u5173\u901a\u8fc7").templateType(template.getTemplateType()).signature(null).build();
    }

    public SignatureBean callCreateSignature(ChannelConfigCache channelConfig, String signName, String signSource, String remark, String fileSuffix, String fileContents, String sceneType, String isOnline, String webSite, String app) {
        return null;
    }

    @Deprecated
    public SignatureBean callUpdateSignature(ChannelConfigCache channelConfig, String signName, String signSource, String remark, String fileSuffix, String fileContents) {
        return null;
    }

    public SignatureBean callDeleteSignature(ChannelConfigCache channelConfig, String sigName, String signatureId) {
        return null;
    }

    @Deprecated
    public SignatureBean callQuerySignature(ChannelConfigCache channelConfig) {
        return null;
    }

    private SmsResBean sendSmsDomestic(Map<String, String> param, Map<String, String> paramJson) throws MessageException {
        try {
            String lengthJson = paramJson.remove("length");
            if (param != null && param.size() > 0) {
                log.info("\u56fd\u90fd\u53d1\u9001\u53d8\u91cf\u77ed\u4fe1:{}", paramJson);
                GuoduSmsSendResponse smsRes = GuoduSmsUtil.sendVariableSms(paramJson);
                if (!StringUtils.isEmpty((Object)lengthJson)) {
                    Map length = (Map)JSON.parseObject((String)lengthJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
                    smsRes.setMsgId("=GUODU:" + smsRes.getMsgId() + "=GUODU:" + JSON.toJSONString((Object)length));
                }
                log.info("\u56fd\u90fd\u53d1\u9001\u666e\u901a\u53d8\u91cf\u77ed\u4fe1\u8fd4\u56de\u53c2\u6570:{}", JSON.toJSON((Object)smsRes));
                return this.commonResponse(smsRes);
            }
            log.info("\u56fd\u90fd\u53d1\u9001\u666e\u901a\u77ed\u4fe1:{}", paramJson);
            GuoduSmsSendResponse smsRes = GuoduSmsUtil.sendSms(paramJson);
            log.info("\u56fd\u90fd\u53d1\u9001\u666e\u901a\u77ed\u4fe1\u8fd4\u56de\u53c2\u6570:{}", JSON.toJSON((Object)smsRes));
            List guoduMessages = (List)JSON.parseObject((String)smsRes.getMessages().toString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            Map<String, Long> countGroupByPhone = guoduMessages.stream().collect(Collectors.groupingBy(GuoduMessage::getDesmobile, Collectors.counting()));
            String msgids = guoduMessages.stream().map(GuoduMessage::getMsgid).collect(Collectors.joining(","));
            smsRes.setMsgId("=GUODU:" + msgids + "=GUODU:" + JSON.toJSONString(countGroupByPhone));
            return this.commonResponse(smsRes);
        }
        catch (Exception e) {
            log.error("\u56fd\u90fd\u53d1\u9001\u56fd\u5185\u77ed\u4fe1\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.CHUANGLAN_ERROR.getErrCode()).errCodeDes("\u53d1\u9001\u77ed\u4fe1Server:" + e.getMessage()).build();
        }
    }

    public SmsResBean callSendSms(ChannelConfigCache channelConfig, String phones, String templateCode, Map<String, String> param, String templateContent, String signature, String batchid) throws MessageException {
        Map paramMap;
        List account = JSON.parseArray((String)channelConfig.getAccountJson(), MessageAccount.class);
        Assert.notNull((Object)account);
        MessageAccount messageAccount = (MessageAccount)account.get(0);
        try {
            paramMap = GuoduSmsUtil.getParamMap((String)messageAccount.getAccessKeyId(), (String)messageAccount.getSecret(), (String)templateContent, param, (String)phones, (String)templateCode);
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u5904\u7406\u56fd\u90fd\u77ed\u4fe1\u5165\u53c2\u5931\u8d25 msg:{}  e:{}", (Object)e.getMessage(), (Object)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.GUODU_SMS_PARAM_BUILD_ERROR.getErrCode()).errCodeDes(BizvaneExceptionEnum.GUODU_SMS_PARAM_BUILD_ERROR.getErrCodeDes()).build();
        }
        log.info("\u56fd\u90fd\u53d1\u9001\u77ed\u4fe1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)paramMap));
        return this.sendSmsDomestic(param, paramMap);
    }

    public SmsResBean callSendSmsBatch(ChannelConfigCache channelConfig, String templateCode, String templateContent, List<BatchOperationMessage> list, List<String> phones, String batchid) throws MessageException {
        Map paramMap;
        List accounts = JSON.parseArray((String)channelConfig.getAccountJson(), MessageAccount.class);
        Assert.notNull((Object)accounts);
        MessageAccount messageAccount = (MessageAccount)accounts.get(0);
        templateContent = "\u3010" + list.get(0).getSignature() + "\u3011" + templateContent;
        try {
            paramMap = GuoduSmsUtil.getParamMap((String)messageAccount.getAccessKeyId(), (String)messageAccount.getSecret(), (String)templateContent, list, phones, (String)templateCode);
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u5904\u7406\u56fd\u90fd\u53d8\u91cf\u77ed\u4fe1\u5165\u53c2\u5931\u8d25 msg:{}  e:{}", (Object)e.getMessage(), (Object)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.GUODU_SMS_PARAM_BUILD_ERROR.getErrCode()).errCodeDes(BizvaneExceptionEnum.GUODU_SMS_PARAM_BUILD_ERROR.getErrCodeDes()).build();
        }
        log.info("\u56fd\u90fd\u6279\u91cf\u53d1\u9001\u77ed\u4fe1\u5165\u53c2[\u591a\u4e86lengthMap\u4e0d\u8981\u7d27\uff0c\u540e\u9762\u4ee3\u7801\u4e2d\u5df2\u7ecf\u53bb\u6389\u4e86]:{}", (Object)JSON.toJSONString((Object)paramMap));
        return this.sendSmsDomestic(!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty((Map)list.get(0).getParams()) ? list.get(0).getParams() : null, paramMap);
    }

    @Deprecated
    public SmsResBean callQuerySms(ChannelConfigCache channelConfig, String phone, String sendDate, String pageSize, String currentPage, String requestId) {
        return null;
    }

    private SmsResBean commonResponse(GuoduSmsSendResponse smsResvari) {
        return SmsResBean.builder().msgId(smsResvari.getMsgId()).time("").failNum("").successNum("").errorCode(smsResvari.getCode()).errorReason(smsResvari.getErrorMsg()).build();
    }
}

