/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.component;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.bizvane.base.common.bean.SmsResBean;
import com.bizvane.message.cache.ChannelCacheComponent;
import com.bizvane.message.cache.MerchantCacheCompoent;
import com.bizvane.message.cache.TemplateCacheComponent;
import com.bizvane.message.cache.entity.ChannelConfigCache;
import com.bizvane.message.cache.entity.TemplateCacheBean;
import com.bizvane.message.component.BatchOperationMessage;
import com.bizvane.message.component.bean.BizvaneExceptionEnum;
import com.bizvane.message.component.bean.MessageException;
import com.bizvane.message.component.bean.MessageStrategyEnum;
import com.bizvane.message.component.bean.SignatureBean;
import com.bizvane.message.component.bean.TemplateBean;
import com.bizvane.message.entity.Template;
import com.bizvane.message.service.MessageFlowService;
import com.bizvane.message.service.TemplateService;
import com.bizvane.message.utils.Constant;
import com.bizvane.message.utils.MessageChannelSuffixConverter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BaseComponent {
    private static final Logger log = LoggerFactory.getLogger(BaseComponent.class);
    @Autowired
    private ChannelCacheComponent channelCacheComponent;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private MessageFlowService messageFlowService;
    private static final Integer SMS_MAX_SIZE_THRESHOLD = 100;
    @Autowired
    private MerchantCacheCompoent merchantCacheCompoent;
    @Autowired
    private TemplateCacheComponent templateCacheComponent;

    public TemplateBean createTemplate(String merchantId, String channelType, String templateName, String templateType, String content, String remark, String sign, String sysCode, String originalContent, String attach, String postFix) throws MessageException {
        log.info("\u521b\u5efa\u6a21\u677f\u5165\u53c2:merchantId:{},channelType:{},templateName:{},templateType:{}", new Object[]{merchantId, channelType, templateName, templateType});
        String channelTypeWithSuffix = MessageChannelSuffixConverter.getSuitableSuffix((String)channelType, (String)templateType);
        ChannelConfigCache channel = this.channelCacheComponent.get(merchantId, channelType, channelTypeWithSuffix);
        TemplateBean templateBean = this.callCreateTemplate(channel, templateName, templateType, content, remark, sign, postFix);
        Template template = this.templateService.save(channel.getChannelId(), merchantId, templateBean.getTemplateCode(), Integer.valueOf(Integer.parseInt(templateBean.getStatus())), templateBean.getContent(), templateName, templateType, remark, Constant.ONE, sysCode, originalContent, attach, postFix);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        templateBean.setCreateTime(formatter.format(template.getCreateTime()));
        templateBean.setOriginalContent(originalContent);
        templateBean.setAttach(attach);
        templateBean.setSysCode(sysCode);
        return templateBean;
    }

    public TemplateBean queryTemplate(String merchantId, String channelType, String templateCode) throws MessageException {
        log.info("\u67e5\u8be2\u6a21\u677f\u5165\u53c2:merchantId:{},channelType:{},templateCode:{}", new Object[]{merchantId, channelType, templateCode});
        TemplateCacheBean cachedBean = this.templateCacheComponent.get(merchantId, channelType, templateCode);
        if (cachedBean == null) {
            return null;
        }
        if (cachedBean.getStatus().equals(Constant.ONE) || cachedBean.getStatus().equals(Constant.TWO)) {
            TemplateBean templateBean = TemplateBean.builder().templateType(cachedBean.getTemplateType()).templateName(cachedBean.getTemplateName()).content(cachedBean.getContent()).status(cachedBean.getStatus().toString()).remark(cachedBean.getRemark()).auditReason(cachedBean.getAuditReason()).originalContent(cachedBean.getOriginalContent()).attach(cachedBean.getAttach()).createTime(cachedBean.getCreateTime()).sysCode(cachedBean.getSysCode()).templateCode(cachedBean.getTemplateCode()).postFix(cachedBean.getPostFix()).build();
            return templateBean;
        }
        String channelTypeWithSuffix = MessageChannelSuffixConverter.getSuitableSuffix((String)channelType, (String)cachedBean.getTemplateType());
        ChannelConfigCache channel = this.channelCacheComponent.get(merchantId, channelType, channelTypeWithSuffix);
        log.info("\u8c03\u7528\u8fd0\u8425\u5546\u6a21\u677f\u63a5\u53e3\u67e5\u8be2\u6a21\u677f\u4fe1\u606f");
        TemplateBean templateBean = this.callQueryTemplate(channel, templateCode);
        this.templateService.updateTemplate(templateBean.getTemplateType(), templateBean.getTemplateName(), templateBean.getContent(), Integer.valueOf(Integer.parseInt(templateBean.getStatus())), merchantId, channel.getChannelId(), templateCode, null, Constant.ONE, templateBean.getAuditReason());
        if ("2".equals(templateBean.getStatus()) || "1".equals(templateBean.getStatus())) {
            Template templateCache = Template.builder().templateType(templateBean.getTemplateType()).templateName(cachedBean.getTemplateName()).content(templateBean.getContent()).createTime((Date)DateUtil.parse((CharSequence)cachedBean.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss")).updateTime(new Date()).templateId(templateBean.getTemplateCode()).channelId(channel.getChannelId()).status(Integer.valueOf(Integer.parseInt(templateBean.getStatus()))).remark(cachedBean.getRemark()).reason(templateBean.getAuditReason()).originalContent(cachedBean.getOriginalContent()).attach(cachedBean.getAttach()).sysCode(cachedBean.getSysCode()).postFix(cachedBean.getPostFix()).build();
            this.templateCacheComponent.set(templateCache);
        }
        templateBean.setCreateTime(cachedBean.getCreateTime());
        templateBean.setTemplateName(cachedBean.getTemplateName());
        templateBean.setSysCode(cachedBean.getSysCode());
        templateBean.setOriginalContent(cachedBean.getOriginalContent());
        templateBean.setAttach(cachedBean.getAttach());
        templateBean.setPostFix(cachedBean.getPostFix());
        templateBean.setRemark(cachedBean.getRemark());
        log.info("\u67e5\u8be2\u6a21\u677f\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)templateBean));
        return templateBean;
    }

    public void sendSms(String merchantId, String channelType, String channleTypeSuffix, String phone, String templateCode, String signature, Map<String, String> param, String batchid) throws MessageException {
        log.info("enter sendSms \u5165\u53c2:templateCode{},param:{},phone:{},batchid:{}", new Object[]{templateCode, param, phone, batchid});
        ChannelConfigCache channel = this.channelCacheComponent.get(merchantId, channelType, channleTypeSuffix);
        if (channel == null) {
            log.error("sendSms-->\u5546\u6237\u4e3a:{},\u6e20\u9053\u7c7b\u578b\u662f:{},\u7b7e\u540d\u662f:{} \u7684\u77ed\u4fe1\u6e20\u9053\u4fe1\u606f\u672a\u627e\u5230\u2014\u2014\u5165\u53c2\u6a21\u677f\u7f16\u7801\u662f:{},\u53f7\u7801\u662f:{}", new Object[]{merchantId, channelType, signature, templateCode, phone});
            return;
        }
        log.info("channel:{}", (Object)channel.getAccountJson());
        TemplateCacheBean templateCacheBean = this.templateCacheComponent.get(merchantId, channelType, templateCode);
        if (templateCacheBean == null) {
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.TEMPLATE_NOT_EXIST_ERROR.getErrCode()).errCodeDes(BizvaneExceptionEnum.TEMPLATE_NOT_EXIST_ERROR.getErrCodeDes()).build();
        }
        try {
            String content = StringUtils.isNotBlank((CharSequence)templateCacheBean.getPostFix()) ? BaseComponent.convertContent((TemplateCacheBean)templateCacheBean) : templateCacheBean.getContent();
            log.info("\u8fdb\u5165\u53d1\u77ed\u4fe1\u6e20\u9053\u4e2d");
            SmsResBean smsResBean = this.callSendSms(channel, phone, templateCode, param, content, signature, batchid);
            this.messageFlowService.save(merchantId, channel.getChannelId(), channelType, Constant.ONE, phone, smsResBean.getMsgId().startsWith("=GUODU:") ? null : smsResBean.getMsgId(), templateCode, smsResBean.getRequestId(), smsResBean.getErrorCode(), smsResBean.getErrorReason());
            if (StringUtils.isNotBlank((CharSequence)smsResBean.getMsgId())) {
                this.merchantCacheCompoent.saveBizMerchantRelation(smsResBean.getMsgId(), channel.getMerchantId(), batchid);
            } else {
                log.error("\u53d1\u9001\u77ed\u4fe1\u6ca1\u6709\u62ff\u5230msgId(\u8ba4\u4e3a\u662f\u53d1\u9001\u5931\u8d25) \u5173\u952e\u4fe1\u606f: merchantId:{}  phone:{}", (Object)merchantId, (Object)phone);
            }
        }
        catch (MessageException e) {
            this.messageFlowService.save(merchantId, channel.getChannelId(), channelType, Constant.ONE, phone, null, templateCode, null, e.getErrCode(), e.getErrCodeDes());
        }
    }

    protected static String convertContent(TemplateCacheBean template) {
        String postFix = template.getPostFix();
        String content = template.getContent().contains(postFix) ? template.getContent() : template.getContent().concat(postFix);
        log.info("\u53d1\u9001\u77ed\u4fe1\u5b8c\u6210\u8f6c\u6362\u7684\u77ed\u4fe1\u5185\u5bb9\u662f:{}", (Object)content);
        return content;
    }

    public void sendSmsBatch(String merchantId, List<String> phones, String templateCode, List<String> signatures, List<LinkedHashMap<String, String>> params, String channelType, String channleTypeSuffix, String batchid) throws MessageException {
        log.info("enter sendSmsBatch batchid:{}", (Object)batchid);
        ChannelConfigCache channel = this.channelCacheComponent.get(merchantId, channelType, channleTypeSuffix);
        if (channel == null) {
            log.error("sendSmsBatch-->\u5546\u6237\u4e3a:{},\u6e20\u9053\u7c7b\u578b\u662f:{},\u7b7e\u540d\u662f:{}\u7684\u77ed\u4fe1\u6e20\u9053\u4fe1\u606f\u672a\u627e\u5230\u2014\u2014\u5165\u53c2\u6a21\u677f\u7f16\u7801\u662f:{},\u53f7\u7801\u662f:{}", new Object[]{merchantId, channelType, JSON.toJSON(signatures), templateCode, JSON.toJSON(phones)});
            return;
        }
        if (MessageStrategyEnum.ALI_STRATEGY.getType().equals(channelType)) {
            if (phones == null || phones.size() == 0 || signatures == null || signatures.size() == 0) {
                log.error("sendSmsBatch\u65b9\u6cd5\u91cc phones\u6216signatures\u4e3a\u7a7a");
                return;
            }
            if (phones.size() != signatures.size()) {
                log.error("sendSmsBatch\u65b9\u6cd5\u91cc phones\u6216signatures\u957f\u5ea6\u4e0d\u76f8\u7b49");
                return;
            }
        }
        if (SMS_MAX_SIZE_THRESHOLD.compareTo(phones.size()) < 0) {
            log.error("sendSmsBatch\u65b9\u6cd5\u91cc phones\u957f\u5ea6\u5927\u4e8e100");
            return;
        }
        ArrayList<BatchOperationMessage> list = new ArrayList<BatchOperationMessage>();
        for (int i = 0; i < phones.size(); ++i) {
            BatchOperationMessage message = new BatchOperationMessage();
            if (params != null && params.size() > 0) {
                message.setParams((Map)params.get(i));
            }
            message.setPhone(phones.get(i));
            if (signatures.size() == 1) {
                message.setSignature(signatures.get(0));
            } else {
                message.setSignature(signatures.get(i));
            }
            list.add(message);
        }
        TemplateCacheBean templateCacheBean = this.templateCacheComponent.get(merchantId, channelType, templateCode);
        if (templateCacheBean == null) {
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.TEMPLATE_NOT_EXIST_ERROR.getErrCode()).errCodeDes(BizvaneExceptionEnum.TEMPLATE_NOT_EXIST_ERROR.getErrCodeDes()).build();
        }
        try {
            String content = StringUtils.isNotBlank((CharSequence)templateCacheBean.getPostFix()) ? BaseComponent.convertContent((TemplateCacheBean)templateCacheBean) : templateCacheBean.getContent();
            log.info("\u8fdb\u5165\u53d1\u77ed\u4fe1\u6e20\u9053\u4e2d");
            SmsResBean smsResBean = this.callSendSmsBatch(channel, templateCode, content, list, phones, batchid);
            if (StringUtils.isNotBlank((CharSequence)smsResBean.getMsgId())) {
                this.merchantCacheCompoent.saveBizMerchantRelation(smsResBean.getMsgId(), channel.getMerchantId(), batchid);
            } else {
                log.error("\u6279\u91cf\u53d1\u9001\u77ed\u4fe1\u6ca1\u6709\u62ff\u5230msgId(\u8ba4\u4e3a\u662f\u53d1\u9001\u5931\u8d25) \u5173\u952e\u4fe1\u606f: merchantId:{}  phone:{}", (Object)merchantId, (Object)JSON.toJSONString(phones));
            }
            this.messageFlowService.save(merchantId, channel.getChannelId(), channelType, Constant.ONE, phones.toString(), smsResBean.getMsgId().startsWith("=GUODU:") ? null : smsResBean.getMsgId(), templateCode, smsResBean.getRequestId(), smsResBean.getErrorCode(), smsResBean.getErrorReason());
            log.info("\u6279\u91cf\u53d1\u9001\u77ed\u4fe1\u6d41\u7a0b\u8d70\u5b8c");
        }
        catch (MessageException e) {
            this.messageFlowService.save(merchantId, channel.getChannelId(), channelType, Constant.ONE, phones.toString(), null, templateCode, null, e.getErrCode(), e.getErrCodeDes());
            log.info("\u6279\u91cf\u53d1\u9001\u77ed\u4fe1\u6d41\u7a0b\u7ec8\u6b62");
        }
    }

    public abstract TemplateBean callUpdateTemplate(ChannelConfigCache var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws MessageException;

    public abstract TemplateBean callDeleteTemplate(ChannelConfigCache var1, String var2) throws MessageException;

    protected abstract TemplateBean callCreateTemplate(ChannelConfigCache var1, String var2, String var3, String var4, String var5, String var6, String var7) throws MessageException;

    protected abstract TemplateBean callQueryTemplate(ChannelConfigCache var1, String var2) throws MessageException;

    protected abstract SignatureBean callCreateSignature(ChannelConfigCache var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10) throws MessageException;

    public abstract SignatureBean callUpdateSignature(ChannelConfigCache var1, String var2, String var3, String var4, String var5, String var6) throws MessageException;

    public abstract SignatureBean callDeleteSignature(ChannelConfigCache var1, String var2, String var3) throws MessageException;

    protected abstract SignatureBean callQuerySignature(ChannelConfigCache var1) throws MessageException;

    protected abstract SmsResBean callSendSms(ChannelConfigCache var1, String var2, String var3, Map<String, String> var4, String var5, String var6, String var7) throws MessageException;

    protected abstract SmsResBean callSendSmsBatch(ChannelConfigCache var1, String var2, String var3, List<BatchOperationMessage> var4, List<String> var5, String var6) throws MessageException;

    public abstract SmsResBean callQuerySms(ChannelConfigCache var1, String var2, String var3, String var4, String var5, String var6) throws MessageException;
}

