/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.client.web;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.cache.MerchantCacheCompoent;
import com.bizvane.message.component.CallBackComponent;
import com.bizvane.message.component.bean.MessageCallBackDto;
import com.bizvane.message.component.bean.MessageStrategyEnum;
import com.bizvane.message.utils.SplitNotifyMsgUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class GuoduSmsCallBackController {
    private static final Logger log = LoggerFactory.getLogger(GuoduSmsCallBackController.class);
    @Autowired
    private CallBackComponent callBackComponent;
    @Autowired
    private MerchantCacheCompoent merchantCacheCompoent;

    @GetMapping(value={"deliverMessage"})
    public void callbackDomestic(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        String s = JSON.toJSONString((Object)parameterMap);
        log.info("\u56fd\u90fd\u53d1\u9001\u56fd\u5185\u77ed\u4fe1\u56de\u8c03\u7ed3\u679c:{}", (Object)s);
        try {
            if (StringUtils.isNotBlank((CharSequence)s)) {
                MessageCallBackDto dto = GuoduSmsCallBackController.convertToDto((String)s);
                String midAndBid = this.merchantCacheCompoent.getBizMerchantRelationGuodu(dto.getMsgid());
                if (StringUtils.isNotBlank((CharSequence)midAndBid)) {
                    List split = SplitNotifyMsgUtil.split((String)midAndBid);
                    String merchantid = (String)split.get(0);
                    String batchid = (String)split.get(1);
                    Integer length = this.merchantCacheCompoent.getLengthGuodu(dto.getPhone(), batchid);
                    dto.setLength(length + "");
                    log.info("\u8fdb\u5165\u56de\u8c03\u7b2c\u4e09\u65b9\u65b9\u6cd5");
                    if (this.merchantCacheCompoent.getLock(dto.getPhone(), batchid)) {
                        this.callBackComponent.callBack(merchantid, MessageStrategyEnum.GUODU_STRATEGY.getType(), batchid, JSON.toJSONString((Object)dto));
                    }
                } else {
                    log.error("\u56fd\u90fd\u77ed\u606f\u56de\u8c03\u63a5\u53e3 msgid\u548cbatchid\u4e4b\u95f4\u7684\u5173\u7cfb\u83b7\u53d6\u5931\u8d25\uff0c\u5f53\u524d\u7684\u56de\u8c03\u7684msgid:{},phone:{}", (Object)dto.getMsgid(), (Object)dto.getPhone());
                }
            }
        }
        catch (Exception e) {
            log.error("\u521b\u84ddcallback\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static MessageCallBackDto convertToDto(String s) {
        MessageCallBackDto dto = new MessageCallBackDto();
        JSONObject json = JSONObject.parseObject((String)s);
        String reportTime = json.getJSONArray("RecvTime").getString(0);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        DateTime parse = DateUtil.parse((CharSequence)reportTime, (DateFormat)format);
        String time = parse.toString("yyyy-MM-dd HH:mm:ss");
        dto.setReportTime(time);
        dto.setPhone(json.getJSONArray("SrcMobile").getString(0));
        dto.setStatus("0".equals(json.getJSONArray("Status").getString(0)) ? "SUCCESS" : "FAIL");
        dto.setMsgid(json.getJSONArray("Content").getString(0));
        return dto;
    }
}

