/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.feign.enums.msg;

import com.bizvane.message.feign.enums.msg.MsgBusinessTypeEnum;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum MsgTemplateTypeEnum {
    FLIGHT_TRAVEL("FLIGHT_TRAVEL", "\u51fa\u884c\u63d0\u9192", MsgBusinessTypeEnum.FLIGHT),
    FLIGHT_BOARDING("FLIGHT_BOARDING", "\u767b\u673a\u63d0\u9192", MsgBusinessTypeEnum.FLIGHT),
    FLIGHT_DELAY("FLIGHT_DELAY", "\u822a\u73ed\u5ef6\u8bef\u63d0\u9192", MsgBusinessTypeEnum.FLIGHT),
    FLIGHT_GATE_CHANGE("FLIGHT_GATE_CHANGE", "\u767b\u673a\u53e3\u53d8\u66f4\u63d0\u9192", MsgBusinessTypeEnum.FLIGHT),
    FLIGHT_LUGGAGE_CHANGE("FLIGHT_LUGGAGE_CHANGE", "\u884c\u674e\u8f6c\u76d8\u53d8\u66f4\u63d0\u9192", MsgBusinessTypeEnum.FLIGHT),
    SERVICE_EVALUATION("SERVICE_EVALUATION", "\u670d\u52a1\u8bc4\u4ef7\u63d0\u9192", MsgBusinessTypeEnum.SERVICE, Boolean.TRUE, Boolean.FALSE),
    MEMBER_REGISTRATION("MEMBER_REGISTRATION", "\u4f1a\u5458\u6ce8\u518c\u63d0\u9192", MsgBusinessTypeEnum.MEMBER, Boolean.TRUE),
    INTEGRAL_RECEIVE("INTEGRAL_RECEIVE", "\u79ef\u5206\u5165\u8d26\u63d0\u9192", MsgBusinessTypeEnum.INTEGRAL, Boolean.TRUE),
    INTEGRAL_USE("INTEGRAL_USE", "\u79ef\u5206\u4f7f\u7528\u63d0\u9192", MsgBusinessTypeEnum.INTEGRAL, Boolean.TRUE),
    INTEGRAL_EXPIRE("INTEGRAL_EXPIRE", "\u79ef\u5206\u8fc7\u671f\u63d0\u9192", MsgBusinessTypeEnum.INTEGRAL, Boolean.TRUE),
    COUPON_RECEIVE("COUPON_RECEIVE", "\u5238\u5165\u8d26\u63d0\u9192", MsgBusinessTypeEnum.COUPON, Boolean.TRUE),
    COUPON_USE("COUPON_USE", "\u5238\u4f7f\u7528\u63d0\u9192", MsgBusinessTypeEnum.COUPON, Boolean.TRUE),
    COUPON_EXPIRE("COUPON_EXPIRE", "\u5238\u8fc7\u671f\u63d0\u9192", MsgBusinessTypeEnum.COUPON, Boolean.TRUE),
    ACTIVITY_WINNING("ACTIVITY_WINNING", "\u6d3b\u52a8\u4e2d\u5956\u901a\u77e5", MsgBusinessTypeEnum.ACTIVITY, Boolean.TRUE),
    ACTIVITY_SIGN("ACTIVITY_SIGN", "\u4f1a\u5458\u7b7e\u5230\u901a\u77e5", MsgBusinessTypeEnum.ACTIVITY, Boolean.TRUE),
    ACTIVITY_BEGINS("ACTIVITY_BEGINS", "\u6d3b\u52a8\u5f00\u59cb\u901a\u77e5", MsgBusinessTypeEnum.ACTIVITY, Boolean.TRUE),
    INTEGRAL_ORDER_SEND("INTEGRAL_ORDER_SEND", "\u5546\u57ce\u53d1\u8d27\u901a\u77e5", MsgBusinessTypeEnum.MALL),
    MKT_MASS_MESSAGE("MKT_MASS_MESSAGE", "\u6d88\u606f\u7fa4\u53d1", MsgBusinessTypeEnum.MKT),
    VERIFY_CODE("VERIFY_CODE", "\u9a8c\u8bc1\u7801", MsgBusinessTypeEnum.CAPTCHA);

    private String code;
    private String desc;
    private MsgBusinessTypeEnum businessTypeEnum;
    private boolean preventDisturbance = Boolean.FALSE;
    private boolean checkUrl = Boolean.TRUE;

    private MsgTemplateTypeEnum(String code, String desc, MsgBusinessTypeEnum businessTypeEnum) {
        this.code = code;
        this.desc = desc;
        this.businessTypeEnum = businessTypeEnum;
    }

    private MsgTemplateTypeEnum(String code, String desc, MsgBusinessTypeEnum businessTypeEnum, boolean preventDisturbance) {
        this.code = code;
        this.desc = desc;
        this.businessTypeEnum = businessTypeEnum;
        this.preventDisturbance = preventDisturbance;
    }

    private MsgTemplateTypeEnum(String code, String desc, MsgBusinessTypeEnum businessTypeEnum, boolean preventDisturbance, boolean checkUrl) {
        this.code = code;
        this.desc = desc;
        this.businessTypeEnum = businessTypeEnum;
        this.preventDisturbance = preventDisturbance;
        this.checkUrl = checkUrl;
    }

    public static boolean isCoupon(String templateType) {
        if (StringUtils.isBlank((CharSequence)templateType)) {
            return false;
        }
        return COUPON_RECEIVE.getCode().equals(templateType) || COUPON_USE.getCode().equals(templateType) || COUPON_EXPIRE.getCode().equals(templateType);
    }

    public static boolean isActivity(String templateType) {
        if (StringUtils.isBlank((CharSequence)templateType)) {
            return false;
        }
        return ACTIVITY_WINNING.getCode().equals(templateType) || ACTIVITY_SIGN.getCode().equals(templateType) || ACTIVITY_BEGINS.getCode().equals(templateType);
    }

    public static boolean isTask(String templateType) {
        if (StringUtils.isBlank((CharSequence)templateType)) {
            return false;
        }
        return ACTIVITY_WINNING.getCode().equals(templateType) || ACTIVITY_SIGN.getCode().equals(templateType) || ACTIVITY_BEGINS.getCode().equals(templateType);
    }

    public static boolean isIntegralMall(String templateType) {
        if (StringUtils.isBlank((CharSequence)templateType)) {
            return false;
        }
        return INTEGRAL_ORDER_SEND.getCode().equals(templateType);
    }

    public static boolean preventDisturbance(String templateType) {
        MsgTemplateTypeEnum result = Arrays.stream(MsgTemplateTypeEnum.values()).filter(msgTemplateTypeEnum -> msgTemplateTypeEnum.getCode().equals(templateType)).findFirst().orElse(null);
        return result != null ? result.isPreventDisturbance() : Boolean.FALSE.booleanValue();
    }

    public static MsgTemplateTypeEnum getByCode(String code) {
        return Arrays.stream(MsgTemplateTypeEnum.values()).filter(msgTemplateTypeEnum -> msgTemplateTypeEnum.getCode().equals(code)).findAny().orElse(null);
    }

    public static List<String> getFlightTemplateTypeList() {
        return Arrays.asList(FLIGHT_TRAVEL.getCode(), FLIGHT_BOARDING.getCode(), FLIGHT_DELAY.getCode(), FLIGHT_GATE_CHANGE.getCode(), FLIGHT_LUGGAGE_CHANGE.getCode());
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public MsgBusinessTypeEnum getBusinessTypeEnum() {
        return this.businessTypeEnum;
    }

    public boolean isPreventDisturbance() {
        return this.preventDisturbance;
    }

    public boolean isCheckUrl() {
        return this.checkUrl;
    }
}

