package com.bizvane.messagefacade.models.vo.subscribe;

import com.alibaba.fastjson.annotation.JSONField;
import com.bizvane.messagefacade.models.vo.ActivityMessageVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author yuantq
 * @date 2022/8/22
 */
@Data
public class ActivityBeginMessageVO extends ActivityMessageVO {

    private String activityCode;

    @JSONField(name = "FIELD_MEMBER_CARD_NO")
    @JsonProperty(value = "FIELD_MEMBER_CARD_NO")
    private String FIELD_MEMBER_CARD_NO;

    @JSONField(name = "FIELD_ACTIVITY_NAME")
    @JsonProperty(value = "FIELD_ACTIVITY_NAME")
    private String FIELD_ACTIVITY_NAME;

    /**
     * 时间
     */
    @DateTimeFormat(pattern = "yyyy年MM月dd日 HH:mm:ss")
    @JsonFormat(pattern = "yyyy年MM月dd日 HH:mm:ss", timezone = "GMT+8")
    @JSONField(name = "FIELD_ACTIVITY_START_TIME")
    @JsonProperty(value = "FIELD_ACTIVITY_START_TIME")
    private Date FIELD_ACTIVITY_START_TIME;

    @JSONField(name = "FIELD_ACTIVITY_EXPLAIN")
    @JsonProperty(value = "FIELD_ACTIVITY_EXPLAIN")
    private String FIELD_ACTIVITY_EXPLAIN;

    @JSONField(name = "FIELD_TEXT")
    @JsonProperty(value = "FIELD_TEXT")
    private String FIELD_TEXT;

}
