package com.bizvane.messagefacade.interfaces;

import com.bizvane.messagefacade.models.vo.WxMsgMassDeleteVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 微信群发消息处理feign
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/wechatMsgMass")
@Api(value = "微信群发消息处理", tags = {"微信群发消息处理"})
public interface WechatMsgMassServiceFeign {

	/**
	 * 微信群发图文消息删除
	 *
	 * @param WxMsgMassDeleteVO
	 * @return
	 */
	@ApiOperation(value = "微信群发图文消息删除")
	@RequestMapping(value = "/tuWenMsgDelete", method = RequestMethod.POST)
	@ResponseBody
	ResponseData<String> tuWenMsgDelete(@RequestBody WxMsgMassDeleteVO WxMsgMassDeleteVO);


}
