package com.bizvane.messagefacade.interfaces;

import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author yuantq
 * @date 2022/11/16
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/tuWenRecord")
@Api(value = "微信图文信息", tags = {"微信图文信息"})
public interface MsgTuWenServiceFeign {

    /**
     * 判断活动下的图文消息是否包含已经发送过
     *
     * @param sysBrandId
     * @param mktActivityId
     * @return
     */
    @ApiOperation(value = "判断活动下的图文消息是否包含已经发送过", notes = "判断活动下的图文消息是否包含已经发送过", tags = {"判断活动下的图文消息是否包含已经发送过的"}, httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "sysBrandId", value = "所属品牌id", required = true, dataType = "Long"),
            @ApiImplicitParam(name = "mktActivityId", value = "活动ID", required = true, dataType = "Long")
    })
    @PostMapping("/containsSentTuWenMsgByMktActivityId")
    ResponseData<Boolean> containsSentTuWenMsgByMktActivityId(@RequestParam("sysBrandId") Long sysBrandId,
                                     @RequestParam("mktActivityId") Long mktActivityId);

}
