package com.bizvane.messagefacade.enums.subscribefield;

import com.bizvane.messagefacade.enums.WeChatSubscribeFieldEnum;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yuantq
 * @date 2022/8/23
 */
public enum MemberDowngradeFieldEnum {

    FIELD_1("MEMEBER_DOWNGRADE",WeChatSubscribeFieldEnum.MEMBER_CARD_NO,"FIELD_MEMBER_CARD_NO",Boolean.TRUE),
    FIELD_2("MEMEBER_DOWNGRADE",WeChatSubscribeFieldEnum.LEVEL_CHANGE_TYPE,"FIELD_LEVEL_CHANGE_TYPE",Boolean.TRUE),
    FIELD_3("MEMEBER_DOWNGRADE",WeChatSubscribeFieldEnum.OLD_LEVEL_NAME,"FIELD_OLD_LEVEL_NAME",Boolean.TRUE),
    FIELD_4("MEMEBER_DOWNGRADE",WeChatSubscribeFieldEnum.NEW_LEVEL_NAME,"FIELD_NEW_LEVEL_NAME",Boolean.TRUE),
    FIELD_5("MEMEBER_DOWNGRADE",WeChatSubscribeFieldEnum.LEVEL_CHANGE_TIME,"FIELD_LEVEL_CHANGE_TIME",Boolean.TRUE),
    FIELD_6("MEMEBER_DOWNGRADE",WeChatSubscribeFieldEnum.TEXT,"FIELD_TEXT");

    private String menuCode;

    private WeChatSubscribeFieldEnum weChatSubscribeFieldEnum;

    private String jsonField;

    private Boolean mustNotNull = Boolean.FALSE;

    MemberDowngradeFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
    }

    MemberDowngradeFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField, Boolean mustNotNull) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
        this.mustNotNull = mustNotNull;
    }

    public String getMenuCode() {
        return menuCode;
    }

    public WeChatSubscribeFieldEnum getWeChatSubscribeFieldEnum() {
        return weChatSubscribeFieldEnum;
    }

    public String getJsonField() {
        return jsonField;
    }

    public Boolean getMustNotNull() {
        return mustNotNull;
    }

    public static List<String> mustFieldList() {
        return Arrays.stream(MemberDowngradeFieldEnum.values()).filter(e -> e.getMustNotNull()).map(MemberDowngradeFieldEnum::getJsonField).collect(Collectors.toList());
    }

    public static Map<String, String> codeConvertJsonFieldMap() {
        return Arrays.stream(MemberDowngradeFieldEnum.values()).collect(Collectors.toMap(e -> e.getWeChatSubscribeFieldEnum().getFieldCode(), MemberDowngradeFieldEnum::getJsonField, (a, b) -> b));
    }

}
