package com.bizvane.messagefacade.interfaces;

import com.bizvane.messagefacade.models.vo.SubscribeMessageVO;
import com.bizvane.messagefacade.models.vo.subscribe.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author yuantq
 * @date 2022/8/22
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/weChatAppletSubscribeMessage")
@Api(value = "小程序模板订阅消息", tags = {"API"})
public interface WeChatAppletSubscribeMessageServiceFeign {

    /**
     * 优惠券入账通知
     * @param vo
     * @return
     */
    @ApiOperation(value = "优惠券入账通知")
    @RequestMapping(value = "/couponReceive", method = RequestMethod.POST)
    ResponseData<String> couponReceive(@RequestBody SubscribeMessageVO<CouponReceiveMessageVO> vo);

    /**
     * 优惠券到期通知
     *
     * @param subscribeMessageVO
     * @return
     */
    @ApiOperation(value = "优惠券到期通知")
    @RequestMapping(value = "/couponExpire", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> couponExpire(@RequestBody SubscribeMessageVO<CouponExpireMessageVO> subscribeMessageVO);

    /**
     * 优惠券使用通知
     *
     * @param subscribeMessageVO
     * @return
     */
    @ApiOperation(value = "优惠券使用通知")
    @RequestMapping(value = "/couponUse", method = RequestMethod.POST)
    ResponseData<String> couponUse(@RequestBody SubscribeMessageVO<CouponUseMessageVO> subscribeMessageVO);


    /**
     * 会员升级通知
     *
     * @param subscribeMessageVO
     * @return
     */
    @ApiOperation(value = "会员升级通知")
    @PostMapping(value = "/memberUpgrade")
    ResponseData<String> memberUpgrade(@RequestBody SubscribeMessageVO<MemberUpgradeMessageVO> subscribeMessageVO);

    /**
     * 会员降级通知
     *
     * @param subscribeMessageVO
     * @return
     */
    @ApiOperation(value = "会员降级通知")
    @PostMapping(value = "/memberDowngrade")
    ResponseData<String> memberDowngrade(@RequestBody SubscribeMessageVO<MemberDowngradeMessageVO> subscribeMessageVO);

    /**
     * 积分入账通知
     *
     * @param subscribeMessageVO
     * @return
     */
    @ApiOperation(value = "积分入账通知")
    @PostMapping(value = "/integralAdd")
    ResponseData<String> integralAdd(@RequestBody SubscribeMessageVO<IntegralAddMessageVO> subscribeMessageVO);

    /**
     * 储值余额变动通知
     *
     * @param subscribeMessageVO
     * @return
     */
    @ApiOperation(value = "储值余额变动通知")
    @PostMapping(value = "/rechargeBalanceChange")
    ResponseData<String> rechargeBalanceChange(@RequestBody SubscribeMessageVO<RechargeBalanceChangeMessageVO> subscribeMessageVO);

    /**
     * 储值余额使用提醒
     *
     * @param subscribeMessageVO
     * @return
     */
    @ApiOperation(value = "储值余额使用提醒")
    @PostMapping(value = "/rechargeBalanceUse")
    ResponseData<String> rechargeBalanceUse(@RequestBody SubscribeMessageVO<RechargeBalanceUseMessageVO> subscribeMessageVO);

    /**
     * 活动开始通知
     *
     * @param subscribeMessageVO
     * @return
     */
    @ApiOperation(value = "活动开始通知")
    @PostMapping(value = "/activityBegin")
    ResponseData<String> activityBegin(@RequestBody SubscribeMessageVO<ActivityBeginMessageVO> subscribeMessageVO);


    /**
     * 会员签到提醒
     *
     * @param subscribeMessageVO
     * @return
     */
    @ApiOperation(value = "会员签到提醒")
    @PostMapping(value = "/activityMemberSign")
    ResponseData<String> activityMemberSign(@RequestBody SubscribeMessageVO<ActivityMemberSignMessageVO> subscribeMessageVO);

    /***
     * 商品发货通知
     *
     * @param subscribeMessageVO
     * @return
     */
    @ApiOperation(value = "商品发货通知")
    @PostMapping(value = "/integralOrderSendMessage")
    ResponseData<String> integralOrderSendMessage(@RequestBody SubscribeMessageVO<IntegralOrderSendMessageVO> subscribeMessageVO);

}
