package com.bizvane.messagefacade.enums.subscribefield;

import com.bizvane.messagefacade.enums.WeChatSubscribeFieldEnum;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yuantq
 * @date 2022/8/23
 */
public enum CouponUseFieldEnum {
    FIELD_1("COUPON_USE", WeChatSubscribeFieldEnum.MEMBER_CARD_NO, "FIELD_MEMBER_CARD_NO", Boolean.TRUE),
    FIELD_2("COUPON_USE", WeChatSubscribeFieldEnum.COUPON_NAME, "FIELD_COUPON_NAME", Boolean.TRUE),
    FIELD_3("COUPON_USE", WeChatSubscribeFieldEnum.COUPON_DISCOUNT, "FIELD_COUPON_DISCOUNT", Boolean.TRUE),
    FIELD_4("COUPON_USE", WeChatSubscribeFieldEnum.COUPON_VALID_DATE, "FIELD_COUPON_VALID_DATE", Boolean.TRUE),
    FIELD_5("COUPON_USE", WeChatSubscribeFieldEnum.COUPON_EXPLAIN, "FIELD_COUPON_EXPLAIN"),
    FIELD_6("COUPON_USE", WeChatSubscribeFieldEnum.COUPON_USE_TIME, "FIELD_COUPON_USE_TIME", Boolean.TRUE),
    FIELD_7("COUPON_USE", WeChatSubscribeFieldEnum.TEXT, "FIELD_TEXT");

    private String menuCode;

    private WeChatSubscribeFieldEnum weChatSubscribeFieldEnum;

    private String jsonField;

    private Boolean mustNotNull = Boolean.FALSE;

    CouponUseFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
    }

    CouponUseFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField, Boolean mustNotNull) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
        this.mustNotNull = mustNotNull;
    }

    public String getMenuCode() {
        return menuCode;
    }

    public WeChatSubscribeFieldEnum getWeChatSubscribeFieldEnum() {
        return weChatSubscribeFieldEnum;
    }

    public String getJsonField() {
        return jsonField;
    }

    public Boolean getMustNotNull() {
        return mustNotNull;
    }

    public static List<String> mustFieldList() {
        return Arrays.stream(CouponUseFieldEnum.values()).filter(e -> e.getMustNotNull()).map(CouponUseFieldEnum::getJsonField).collect(Collectors.toList());
    }

    public static Map<String, String> codeConvertJsonFieldMap() {
        return Arrays.stream(CouponUseFieldEnum.values()).collect(Collectors.toMap(e -> e.getWeChatSubscribeFieldEnum().getFieldCode(), CouponUseFieldEnum::getJsonField, (a, b) -> b));
    }
}
