package com.bizvane.messagefacade.models.vo.subscribe;

import com.alibaba.fastjson.annotation.JSONField;
import com.bizvane.messagefacade.models.vo.IntegralMessageVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author yuantq
 * @date 2022/8/22
 */
@Data
public class IntegralAddMessageVO extends IntegralMessageVO {

    @JSONField(name = "FIELD_MEMBER_CARD_NO")
    @JsonProperty(value = "FIELD_MEMBER_CARD_NO")
    private String FIELD_MEMBER_CARD_NO;

    @JSONField(name = "FIELD_INTEGRAL_INCOME_NUM")
    @JsonProperty(value = "FIELD_INTEGRAL_INCOME_NUM")
    private Integer FIELD_INTEGRAL_INCOME_NUM;

    /**
     * 此处时间
     */
    @DateTimeFormat(pattern = "yyyy年MM月dd日 HH:mm:ss")
    @JsonFormat(pattern = "yyyy年MM月dd日 HH:mm:ss", timezone = "GMT+8")
    @JSONField(name = "FIELD_INTEGRAL_INCOME_TIME")
    @JsonProperty(value = "FIELD_INTEGRAL_INCOME_TIME")
    private Date FIELD_INTEGRAL_INCOME_TIME;

    @JSONField(name = "FIELD_PERSONAL_INTEGRAL")
    @JsonProperty(value = "FIELD_PERSONAL_INTEGRAL")
    private Integer FIELD_PERSONAL_INTEGRAL;

    @JSONField(name = "FIELD_INTEGRAL_CHANG_TYPE")
    @JsonProperty(value = "FIELD_INTEGRAL_CHANG_TYPE")
    private String FIELD_INTEGRAL_CHANG_TYPE;


    @JSONField(name = "FIELD_TEXT")
    @JsonProperty(value = "FIELD_TEXT")
    private String FIELD_TEXT;

}
