package com.bizvane.messagefacade.enums.subscribefield;

import com.bizvane.messagefacade.enums.WeChatSubscribeFieldEnum;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yuantq
 * @date 2022/8/23
 */
public enum MemberUpgradeFieldEnum {

    FIELD_1("MEMEBER_UPGRADE", WeChatSubscribeFieldEnum.MEMBER_CODE, "FIELD_MEMBER_CODE", Boolean.TRUE),
    FIELD_2("MEMEBER_UPGRADE", WeChatSubscribeFieldEnum.LEVEL_CHANGE_TYPE, "FIELD_LEVEL_CHANGE_TYPE"),
    FIELD_3("MEMEBER_UPGRADE", WeChatSubscribeFieldEnum.OLD_LEVEL_NAME, "FIELD_OLD_LEVEL_NAME"),
    FIELD_4("MEMEBER_UPGRADE", WeChatSubscribeFieldEnum.NEW_LEVEL_NAME, "FIELD_NEW_LEVEL_NAME"),
    FIELD_5("MEMEBER_UPGRADE", WeChatSubscribeFieldEnum.LEVEL_CHANGE_TIME, "FIELD_LEVEL_CHANGE_TIME"),
    FIELD_6("MEMEBER_UPGRADE", WeChatSubscribeFieldEnum.TEXT, "FIELD_TEXT");

    private String menuCode;

    private WeChatSubscribeFieldEnum weChatSubscribeFieldEnum;

    private String jsonField;

    private Boolean mustNotNull = Boolean.FALSE;

    MemberUpgradeFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
    }

    MemberUpgradeFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField, Boolean mustNotNull) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
        this.mustNotNull = mustNotNull;
    }

    public String getMenuCode() {
        return menuCode;
    }

    public WeChatSubscribeFieldEnum getWeChatSubscribeFieldEnum() {
        return weChatSubscribeFieldEnum;
    }

    public String getJsonField() {
        return jsonField;
    }

    public Boolean getMustNotNull() {
        return mustNotNull;
    }

    public static List<String> mustFieldList() {
        return Arrays.stream(MemberUpgradeFieldEnum.values()).filter(e -> e.getMustNotNull()).map(MemberUpgradeFieldEnum::getJsonField).collect(Collectors.toList());
    }

    public static Map<String, String> codeConvertJsonFieldMap() {
        return Arrays.stream(MemberUpgradeFieldEnum.values()).collect(Collectors.toMap(e -> e.getWeChatSubscribeFieldEnum().getFieldCode(), MemberUpgradeFieldEnum::getJsonField, (a, b) -> b));
    }

}
