package com.bizvane.messagefacade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 删除微信群发消息vo
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class WxMsgMassDeleteVO implements Serializable {

	private static final long serialVersionUID = 1L;


	@ApiModelProperty(value = "所属企业id", name = "sysCompanyId", required = false, example = "")
	private Long sysCompanyId;

	@ApiModelProperty(value = "品牌", name = "brandId", required = false, example = "")
	private Long brandId;

	@ApiModelProperty(value = "任务Id或者任务code", name = "taskId", required = false, example = "")
	private String taskId;

	@ApiModelProperty(value = "模板id", name = "mediaId", required = false, example = "")
	private String mediaId;

	@ApiModelProperty(value = "消息类型", name = "msgType", required = false, example = "")
	private String msgType;

	@ApiModelProperty(value = "分组名称", name = "groupName", required = false, example = "")
	private String groupName;
}
