package com.bizvane.messagefacade.interfaces;

import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 获取短信模板
 * @author Bizvane
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/msgSmsTemp")
public interface MsgSmsTempServiceFeign {
    /**
     * 查短信模板消息
     *
     * @param businessType
     * @return
     */
    @ApiOperation(value = "查询短信模板消息", notes = "查询短信模板消息", tags = {"短信模板查询"}, httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "sysBrandId", value = "所属品牌id", required = true, dataType = "Long"),
            @ApiImplicitParam(name = "businessType", value = "业务类型", required = true, dataType = "String"),
            @ApiImplicitParam(name = "templateType", value = "短信模板类型", required = true, dataType = "String")
    })
    @RequestMapping("/getTemplateType")
    ResponseData<Object> getTemplate(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("businessType") String businessType, @RequestParam("templateType") String templateType);
}
