package com.bizvane.messagefacade.interfaces;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.messagebase.common.constants.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;


/**
 * 短信通用消息
 *
 * @author liangzanwen
 * 2018年8月14日下午8:22:40
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/messageParamConvert")
@Api(value = "消息通知会员基础字段转换", tags = {"消息通知会员基础字段转换"})
public interface MessageParamConvertServiceFeign {

	/**
	 * 短信活动消费模板替换会员基础字段
	 *
	 * @param jsonObject
	 * @return
	 */
	ResponseData<String> smsTemplateParamConvert(@RequestBody JSONObject jsonObject);
}
