package com.bizvane.messagefacade.interfaces;

import com.bizvane.base.remote.dto.TemplateDto;
import com.bizvane.messagefacade.models.dto.ExpirePointMemebersVO;
import com.bizvane.messagefacade.models.vo.ExpirePointSearchVO;
import com.bizvane.messagefacade.models.vo.ExpirePointVO;
import com.bizvane.messagefacade.models.vo.SmsTemplateVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 获取短信模板
 * @author Bizvane
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/pointMsg")
public interface SendPointMsgServiceFeign {

    /**
     *  积分过期消息通知
     * @param expirePointVO
     * @return
     */
    @PostMapping(value = "/sendTemplateMsg")
    ResponseData<String> sendMsg(@RequestBody ExpirePointVO expirePointVO);

    /**
     *  查询积分过期会员信息
     * @param expirePointSearchVO
     * @return
     */
    @PostMapping(value = "/searchMsgRecord")
    ResponseData<PageInfo<ExpirePointMemebersVO>> searchMsgRecord(@RequestBody ExpirePointSearchVO expirePointSearchVO);


}
