package com.bizvane.messagefacade.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 微信图文消息发送状态枚举
 * @author huangxinliu
 * @date: 2021/1/15 12:00
 */
@AllArgsConstructor
@Getter
public enum MsgWxTuwenSendStatusEnum {

    SEND_SUCC(0, "发送成功"),
    SEND_FAIL(1, "发送失败"),
    DEL_SUCC(3, "删除成功"),
    ;

    private Integer code;
    private String msg;

    public static String getMsg(Integer code){
        for (MsgWxTuwenSendStatusEnum c: MsgWxTuwenSendStatusEnum.values()){
            if(c.getCode().equals(code)){
                return c.getMsg();
            }
        }
        return null;
    }

}

