package com.bizvane.messagefacade.interfaces;

import com.bizvane.messagebase.common.constants.ResponseData;
import com.bizvane.messagebase.model.po.MsgShortchainPO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/msgShortchain")
@Api(value = "短信短链", tags = {"短信短链"})
public interface MsgShortchainServiceFeign {


    @ApiOperation(value = "根据短链码查询短信短链信息")
    @RequestMapping(value = "selectByShortchainCode",method = RequestMethod.GET)
    ResponseData<MsgShortchainPO> selectByShortchainCode(@RequestParam String shortchainCode);
}
