package com.bizvane.messagefacade.enums;

/**
 * 短息渠道类型
 */
public enum ChannelTypeEnum {
//  '渠道类型 1 ALIBABAMESSAGE 2 CHUANGLANMESSAGE'
    SMS_ALI(1, "ALIBABAMESSAGE"),
    SMS_CHUANGLAN(2, "CHUANGLANMESSAGE");


    ChannelTypeEnum(Integer type, String code) {
        this.type = type;
        this.code = code;
    }

    private final Integer type;
    private final String code;

    public Integer getType() {
        return type;
    }

    public String getCode() {
        return code;
    }

    public static String getCode(Integer type) {
        for (ChannelTypeEnum value : ChannelTypeEnum.values()) {
            if (value.type.equals(type)) {
                return value.getCode();
            }
        }
        return null;
    }
}
