package com.bizvane.messagefacade.interfaces;

import com.bizvane.base.remote.dto.TemplateDto;
import com.bizvane.messagefacade.models.vo.SmsTemplateVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 获取短信模板
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/smsTemplate")
public interface SmsTemplateServiceFeign {

    /**
     *  根据模板code 和当前登陆用户信息获取短信模板
     * @param smsTemplateVo
     * @param sysAccountPO
     * @return
     */
    @PostMapping(value = "/getTemplateRpc")
    ResponseData<TemplateDto> getTemplate(SmsTemplateVo smsTemplateVo, SysAccountPO sysAccountPO);


}
