package com.bizvane.messagefacade.enums;

/**
 * 短信模板类型
 */
public enum SmsTemplateTypeEnum {
//    模板类型,可选值: 0：验证码。 1：短信通知 2：推广短信。 3：国际/港澳台消息
    SMS_YZ(0, "YZ"),
    SMS_TZ(1, "TZ"),
    SMS_YX(2, "YX"),
    SMS_GJ(3, "GJ");

    SmsTemplateTypeEnum(Integer type, String code) {
        this.type = type;
        this.code = code;
    }

    private final Integer type;
    private final String code;

    public Integer getType() {
        return type;
    }

    public String getCode() {
        return code;
    }

    public static String getCode(Integer type) {
        for (SmsTemplateTypeEnum value : SmsTemplateTypeEnum.values()) {
            if (value.type.equals(type)) {
                return value.getCode();
            }
        }
        return null;
    }
}
