package com.bizvane.messagefacade.models.vo;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yunjie.tian on 2018/7/16.
 */
public class ActivityMessageVO implements Serializable {

	private static final long serialVersionUID = 1L;

	//公共必填字段


	//微信定向运营活活动模板-必填字段
	@ApiModelProperty(value = "会员code", name = "memberCode", required = false, example = "")
	private String memberCode;
	@ApiModelProperty(value = "所属品牌名称", name = "sysBrandName", required = false, example = "")
	private String sysBrandName;
	@ApiModelProperty(value = "微信openId", name = "openId", required = false, example = "")
	private String openId;

	@ApiModelProperty(value = "所属品牌id", name = "sysBrandId", required = false, example = "")
	private Long sysBrandId;
	@ApiModelProperty(value = "导航语", name = "navigation", required = false, example = "")
	private String navigation;
	@ApiModelProperty(value = "活动名称", name = "activityName", required = false, example = "")
	private String activityName;
	@ApiModelProperty(value = "活动结果", name = "activityInterests", required = false, example = "")
	private String activityInterests;
	@ApiModelProperty(value = "定向运营活动时间", name = "activitytime", required = false, example = "")
	private String activitytime;
	@ApiModelProperty(value = "赞助商家", name = "businessman", required = false, example = "")
	private String businessman;
	private String remark;

	@ApiModelProperty(value = "1立即发送，0定时发送", name = "sendtype", required = false, example = "")
	private String sendtype;

	@ApiModelProperty(value = "定时发送时间", name = "sendtime", required = false, example = "")
	private Date sendtime;
	@ApiModelProperty(value = "会员姓名", name = "memberName", required = false, example = "")
	private String memberName;
	//微信定向运营活活动模板-必填字段


	@ApiModelProperty(value = "企业id", name = "sysCompanyId")
	private Long sysCompanyId;

	@ApiModelProperty(value = "活动开始时间", name = "activityStartDate", required = false, example = "")
	private Date activityStartDate;
	@ApiModelProperty(value = "活动结束时间", name = "activityEndDate", required = false, example = "")
	private Date activityEndDate;


	// 短信活动模板-必填字段

	@ApiModelProperty(value = "公众号名称", name = "pubNum", required = false, example = "")
	private String pubNum;
	@ApiModelProperty(value = "会员手机", name = "memberPhone", required = false, example = "")
	private String memberPhone;
	@ApiModelProperty(value = "短信内容", name = "sendWxmember", required = false, example = "")
	private String sendWxmember;

	@ApiModelProperty(value = "长期活动", name = "activityLongtime", required = false, example = "")
	private String activityLongtime;

	@ApiModelProperty(value = "短信类型：活动ACTIVITY_TEMPLATE_MESSAGE活动消息，任务TASK_TEMPLATE_MESSAGE，红包RED_TEMPLATE_MESSAGE", name = "type", required = false, example = "")
	private String templateType;


	@io.swagger.annotations.ApiModelProperty(value = "对应微信上的模板id", name = "wxTemplateId", required = false, example = "")
	private String wxTemplateId;

	@io.swagger.annotations.ApiModelProperty(value = "头部内容", name = "wxTemplateId", required = false, example = "")
	private String first;
	// 选择模板"content": {"1": "服务项目","2": "完成时间"}
	//顺序保存{"1": "输入服务项目值","2": "输入完成时间值"}
	@io.swagger.annotations.ApiModelProperty(value = "中间动态内容JSONObject", name = "wxTemplateId", required = false, example = "")
	private JSONObject content;
	@io.swagger.annotations.ApiModelProperty(value = "尾部内容", name = "wxTemplateId", required = false, example = "")
	private String tail;

	private String unl;

	/**
	 *批量短信的店铺的线上服务门店的codes
	 */
	public String memberOnlineServiceStoreCodes;

	/**
	 * 批量短信的会员姓名s
	 */
	public String memberNames;

	/**
	 *多个手机号,用于批量发送
	 */
	private String phones;


	/**
	 * 国内短信模板编号
	 */
	public String templateCodeCn;// 国内模板编号

	/**
	 * 国际短信模板编号
	 */
	public String templateCodeIntl;//国际模板编号

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getWxTemplateId() {
		return wxTemplateId;
	}

	public void setWxTemplateId(String wxTemplateId) {
		this.wxTemplateId = wxTemplateId;
	}

	public String getFirst() {
		return first;
	}

	public void setFirst(String first) {
		this.first = first;
	}

	public JSONObject getContent() {
		return content;
	}

	public void setContent(JSONObject content) {
		this.content = content;
	}


	public String getTail() {
		return tail;
	}

	public void setTail(String tail) {
		this.tail = tail;
	}

	public String getNavigation() {
		return navigation;
	}

	public void setNavigation(String navigation) {
		this.navigation = navigation;
	}

	public String getActivitytime() {
		return activitytime;
	}

	public void setActivitytime(String activitytime) {
		this.activitytime = activitytime;
	}

	public String getBusinessman() {
		return businessman;
	}

	public void setBusinessman(String businessman) {
		this.businessman = businessman;
	}

	public String getSendtype() {
		return sendtype;
	}

	public void setSendtype(String sendtype) {
		this.sendtype = sendtype;
	}

	public Date getSendtime() {
		return sendtime;
	}

	public void setSendtime(Date sendtime) {
		this.sendtime = sendtime;
	}

	public String getTemplateType() {
		return templateType;
	}

	public void setTemplateType(String templateType) {
		this.templateType = templateType;
	}

	public String getActivityLongtime() {
		return activityLongtime;
	}

	public void setActivityLongtime(String activityLongtime) {
		this.activityLongtime = activityLongtime;
	}

	public String getSysBrandName() {
		return sysBrandName;
	}

	public void setSysBrandName(String sysBrandName) {
		this.sysBrandName = sysBrandName;
	}

	public Long getSysCompanyId() {
		return sysCompanyId;
	}

	public void setSysCompanyId(Long sysCompanyId) {
		this.sysCompanyId = sysCompanyId;
	}

	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public Long getSysBrandId() {
		return sysBrandId;
	}

	public void setSysBrandId(Long sysBrandId) {
		this.sysBrandId = sysBrandId;
	}

	public String getActivityName() {
		return activityName;
	}

	public void setActivityName(String activityName) {
		this.activityName = activityName;
	}

	public Date getActivityStartDate() {
		return activityStartDate;
	}

	public void setActivityStartDate(Date activityStartDate) {
		this.activityStartDate = activityStartDate;
	}

	public Date getActivityEndDate() {
		return activityEndDate;
	}

	public void setActivityEndDate(Date activityEndDate) {
		this.activityEndDate = activityEndDate;
	}

	public String getActivityInterests() {
		return activityInterests;
	}

	public void setActivityInterests(String activityInterests) {
		this.activityInterests = activityInterests;
	}

	public String getUnl() {
		return unl;
	}

	public void setUnl(String unl) {
		this.unl = unl;
	}

	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	public String getPubNum() {
		return pubNum;
	}

	public void setPubNum(String pubNum) {
		this.pubNum = pubNum;
	}

	public String getMemberPhone() {
		return memberPhone;
	}

	public void setMemberPhone(String memberPhone) {
		this.memberPhone = memberPhone;
	}

	public String getSendWxmember() {
		return sendWxmember;
	}

	public void setSendWxmember(String sendWxmember) {
		this.sendWxmember = sendWxmember;
	}

	public String getOpenId() {
		return openId;
	}

	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public String getMemberOnlineServiceStoreCodes() {
		return memberOnlineServiceStoreCodes;
	}

	public void setMemberOnlineServiceStoreCodes(String memberOnlineServiceStoreCodes) {
		this.memberOnlineServiceStoreCodes = memberOnlineServiceStoreCodes;
	}

	public String getMemberNames() {
		return memberNames;
	}

	public void setMemberNames(String memberNames) {
		this.memberNames = memberNames;
	}

	public String getPhones() {
		return phones;
	}

	public void setPhones(String phones) {
		this.phones = phones;
	}

	public String getTemplateCodeCn() {
		return templateCodeCn;
	}

	public void setTemplateCodeCn(String templateCodeCn) {
		this.templateCodeCn = templateCodeCn;
	}

	public String getTemplateCodeIntl() {
		return templateCodeIntl;
	}

	public void setTemplateCodeIntl(String templateCodeIntl) {
		this.templateCodeIntl = templateCodeIntl;
	}
}
