package com.bizvane.messagefacade.models.vo;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * 短信
 */
public class SmsTemplateVo {

    // 商户号
    @NotEmpty(message = "商户号不能为空")
    private String merchantId;

    // 模板code
    private String templateCode;

    // 模板名称
    @NotEmpty(message = "模板名称不能为空")
    private String templateName;

    private String type;

    // 品牌Code
    private String brandCode;

    // 审核状态，可选值：
    //0:审核中,1:审核通过 2:审核失败
    private String status;

    // 模板内容 返回时参数
    private String content;

    // 短信模板内容(转化后)
    private String templateContent;

    // 短信模板原始内容
    @NotEmpty(message = "模板内容不能为空")
    private String originalContent;

    // 模板类型（0：验证码。1：短信通知 2：推广短信。3：国际/港澳台消息）
    @NotNull(message = "模板类型不能为空")
    private Integer templateType;

    // 备注
    @NotEmpty(message = "备注不能为空")
    private String remark;

//    营销模板后缀（例如：回T退订）
    private String postFix;

    // 创建日期
    private String createTime;

    //  审核日期
    private String auditDate;
    // 审核原因(错误描述)
    private String auditReason;

    // 当前页
    private Integer pageNum = 1;

    // 最大条数
    private Integer pageSize = 10;
    // 总条数
    private Integer itemCount;
    // 中台生成模板编号
    private String sysCode;

    // 签名
    private String sign;


    // 渠道类型 阿里：ALIBABAMESSAGE
    //创蓝：（CHUANGLANMESSAGE）
    private String channelType;

    //  对应key:中文占位符
    @NotEmpty(message = "对应字段数组不能为空")
    private String attach;

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getTemplateContent() {
        return templateContent;
    }

    public void setTemplateContent(String templateContent) {
        this.templateContent = templateContent;
    }

    public String getOriginalContent() {
        return originalContent;
    }

    public void setOriginalContent(String originalContent) {
        this.originalContent = originalContent;
    }

    public Integer getTemplateType() {
        return templateType;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getPostFix() {
        return postFix;
    }

    public void setPostFix(String postFix) {
        this.postFix = postFix;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getAuditDate() {
        return auditDate;
    }

    public void setAuditDate(String auditDate) {
        this.auditDate = auditDate;
    }

    public String getAuditReason() {
        return auditReason;
    }

    public void setAuditReason(String auditReason) {
        this.auditReason = auditReason;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getItemCount() {
        return itemCount;
    }

    public void setItemCount(Integer itemCount) {
        this.itemCount = itemCount;
    }

    public String getSysCode() {
        return sysCode;
    }

    public void setSysCode(String sysCode) {
        this.sysCode = sysCode;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getAttach() {
        return attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }
}
