package com.bizvane.messagefacade.models.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@ApiModel(value = "微信-储蓄卡余额变动提醒")
@Data
public class RechargeCardMessageVO implements Serializable {


	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "会员code", name = "memberCode", required = false, example = "")
	private String memberCode;

	@ApiModelProperty(value = "变动类型", name = "changeType", required = false, example = "")
	private String changeType;

	@ApiModelProperty(value = "变动金额", name = "changeAmount", required = false, example = "")
	private String changeAmount;

	@ApiModelProperty(value = "余额", name = "balanceAmount", required = false, example = "")
	private String balanceAmount;

	@ApiModelProperty(value = "变动时间", name = "changeTime", required = false, example = "")
	private Date changeTime;

	//短信必填字段
	@ApiModelProperty(value = "会员名称", name = "memberName", required = false, example = "")
	private String memberName;

	@ApiModelProperty(value = "订单号", name = "orderNo", required = false, example = "")
	private String orderNo;

	@ApiModelProperty(value = "品牌id", name = "sysBrandId", required = false, example = "")
	private Long sysBrandId;

	@ApiModelProperty(value = "手机号", name = "memberPhone", required = false, example = "")
	private String memberPhone;

	@ApiModelProperty(value = "储蓄卡号", name = "cardNo", required = false, example = "")
	private String cardNo;

	@ApiModelProperty(value = "公众号名称", name = "nickName", required = false, example = "")
	private String nickName;

	@ApiModelProperty(value = "1非微信会员,没有关注，2是微信已经关注", name = "sendWxmember", required = false, example = "")
	private String sendWxmember;

	@ApiModelProperty(value = "企业id", name = "sysCompanyId")
	private Long sysCompanyId;


}
