package com.bizvane.messagefacade.interfaces;

import com.bizvane.messagebase.common.constants.ResponseData;
import com.bizvane.messagebase.model.vo.StandardMessageVo;
import com.bizvane.messagebase.model.vo.StandardTemplateVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 消息模块标准接口,不处理任何消息的拼接,直接拿到消息发送.
 */
@FeignClient(value="${feign.client.message.name}",path = "${{feign.client.message.path}/standardMessage")
public interface StandardMessageSmsFeign {

    /**
     * 立即发送短信,不走mq,直接调三方接口
     * @param standardMessageVo
     * @return
     */
    @RequestMapping(value = "/sendSingleMessageImmediately")
    ResponseData sendSingleMessageImmediately(@RequestBody StandardMessageVo standardMessageVo)  ;

    /**
     * 单张走mq
     * @param standardMessageVo
     * @return
     */
    @RequestMapping(value = "/sendSingleMessage")
    ResponseData sendSingleMessage(@RequestBody StandardMessageVo standardMessageVo)  ;

    /**
     * 批量走mq
     * @param standardMessageVo
     * @return
     */
    @RequestMapping(value = "/sendBatchMessage")
    ResponseData sendBatchMessage(@RequestBody StandardMessageVo standardMessageVo)  ;

    /**
     * 根据品牌id和消息类型查找对应的模板内容
     */
    @RequestMapping(value = "/getTemplate")
    ResponseData<String> getTemplateByBrandIdAndTemType(@RequestBody StandardTemplateVo standardTemplateVo);
}
