package com.bizvane.messagefacade.models.vo;

import com.bizvane.messagebase.model.po.MsgWxMiniProTempFieldPO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author gp.n
 * @date 2022-6-8
 */

@Data
public class SaveWeChatMiniProTempRequestVO {
    @ApiModelProperty(notes = "数据主键id")
    private Long msgWxMiniProTempId;

    @ApiModelProperty(notes = "企业id")
    @NotNull(message = "企业id不能为空")
    private Long sysCompanyId;

    @ApiModelProperty(notes = "品牌id")
    @NotNull(message = "品牌id不能为空")
    private Long sysBrandId;

    @ApiModelProperty(notes = "微信模板id")
    @NotBlank(message = "微信模板id不能为空")
    private String wxTempId;

    @ApiModelProperty(notes = "微信模板名称")
    private String wxTempTitle;

    @ApiModelProperty(notes = "微信模板类型")
    private Integer wxTempType;

    @ApiModelProperty(notes = "跳转路径类型0会员中心")
    private Integer urlType;

    @ApiModelProperty(notes = "跳转路径")
    private String url;

    @ApiModelProperty(notes = "模板是否开启:0关闭,1开启")
    private Boolean openStatus;

    @ApiModelProperty(notes = "")
    @NotBlank(message = "消息类型")
    private String businessType;

    @ApiModelProperty(notes = "")
    @NotBlank(message = "场景消息")
    private String templateType;

    @ApiModelProperty(notes = "")
    private String wxTempText;

    @ApiModelProperty(notes = "模板字段集合")
    @NotEmpty(message = "模板字段集合不能为空")
    private List<MsgWxMiniProTempFieldPO> fieldList;

}
