package com.bizvane.messagefacade.enums.vg.subscribefield;

import com.bizvane.messagefacade.enums.vg.WechatSubscribeFieldEnum;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum ActivityWxTemplateSubscribeMessageFieldEnum {

    FIELD_1("ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE",WechatSubscribeFieldEnum.MEMBER_CODE,"FIELD_MEMBER_CODE",Boolean.TRUE),
    FIELD_2("ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE",WechatSubscribeFieldEnum.TEXT,"FIELD_TEXT"),
    FIELD_3("ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE",WechatSubscribeFieldEnum.ACTIVITY_TYPE,"FIELD_ACTIVITY_TYPE",Boolean.TRUE),
    FIELD_4("ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE",WechatSubscribeFieldEnum.ACTIVITY_START_TIME,"FIELD_ACTIVITY_START_TIME",Boolean.TRUE),
    FIELD_5("ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE",WechatSubscribeFieldEnum.ACTIVITY_EXPLAIN,"FIELD_ACTIVITY_EXPLAIN"),
    ;


    private String menuCode;

    private WechatSubscribeFieldEnum wechatSubscribeFieldEnum;

    private String jsonField;

    private Boolean mustNotNull = Boolean.FALSE;

    ActivityWxTemplateSubscribeMessageFieldEnum(String menuCode, WechatSubscribeFieldEnum wechatSubscribeFieldEnum, String jsonField) {
        this.menuCode = menuCode;
        this.wechatSubscribeFieldEnum = wechatSubscribeFieldEnum;
        this.jsonField = jsonField;
    }

    ActivityWxTemplateSubscribeMessageFieldEnum(String menuCode, WechatSubscribeFieldEnum wechatSubscribeFieldEnum, String jsonField, Boolean mustNotNull) {
        this.menuCode = menuCode;
        this.wechatSubscribeFieldEnum = wechatSubscribeFieldEnum;
        this.jsonField = jsonField;
        this.mustNotNull = mustNotNull;
    }

    public String getMenuCode() {
        return menuCode;
    }

    public WechatSubscribeFieldEnum getWechatSubscribeFieldEnum() {
        return wechatSubscribeFieldEnum;
    }

    public String getJsonField() {
        return jsonField;
    }

    public Boolean getMustNotNull() {
        return mustNotNull;
    }

    public static List<String> mustFieldList(){
        return Arrays.stream(ActivityWxTemplateSubscribeMessageFieldEnum.values()).filter(e-> e.getMustNotNull()).map(ActivityWxTemplateSubscribeMessageFieldEnum::getJsonField).collect(Collectors.toList());
    }

    public static Map<String,String> codeConvertJsonFieldMap(){
        return Arrays.stream(ActivityWxTemplateSubscribeMessageFieldEnum.values()).collect(Collectors.toMap(e -> e.getWechatSubscribeFieldEnum().getFieldCode(), ActivityWxTemplateSubscribeMessageFieldEnum::getJsonField, (a, b) -> b));
    }
}
