package com.bizvane.messagefacade.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum WeChatSubscribeTypeEnum {

    COUPON_RECEIVE("COUPON","COUPON_RECEIVE","优惠券入帐通知"),
    COUPON_EXPIRE("COUPON","COUPON_EXPIRE","优惠券到期通知"),
    COUPON_USE("COUPON","COUPON_USE","优惠券使用通知"),
    MEMEBER_UPGRADE("MEMBER","MEMEBER_UPGRADE","会员升级通知"),
    MEMEBER_DOWNGRADE("MEMBER","MEMEBER_DOWNGRADE","会员降级通知"),
    INTEGRAL_ADD("INTEGRAL","INTEGRAL_ADD","积分入账通知"),
    ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE("ACTIVITY","ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE","活动开始通知"),
    MEMBER_SIGN("ACTIVITY","MEMBER_SIGN","会员签到提醒"),
    INTEGRAL_ORDER_SEND("INTEGRAL_SHOP","INTEGRAL_ORDER_SEND","商品发货通知");

    private String businessType;

    private String templateType;

    private String templateName;

    WeChatSubscribeTypeEnum(String businessType, String templateType, String templateName) {
        this.businessType = businessType;
        this.templateType = templateType;
        this.templateName = templateName;
    }

    public String getBusinessType() {
        return businessType;
    }

    public String getTemplateType() {
        return templateType;
    }

    public String getTemplateName() {
        return templateName;
    }

    public static List<String> getTemplateTypeList(){
        return Arrays.stream(WeChatSubscribeTypeEnum.values()).map(WeChatSubscribeTypeEnum::getTemplateType).collect(Collectors.toList());
    }

    /**
     * 判断是否可以立即发送
     */
    public static boolean canSendSubscribeType(String templateType){
        if(MEMEBER_UPGRADE.getTemplateType().equals(templateType)
                || MEMEBER_DOWNGRADE.getTemplateType().equals(templateType)){
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}
