/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.messagefacade.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum WeChatSubscribeTypeEnum {
    COUPON_RECEIVE("COUPON", "COUPON_RECEIVE", "\u4f18\u60e0\u5238\u5165\u5e10\u901a\u77e5"),
    COUPON_EXPIRE("COUPON", "COUPON_EXPIRE", "\u4f18\u60e0\u5238\u5230\u671f\u901a\u77e5"),
    COUPON_USE("COUPON", "COUPON_USE", "\u4f18\u60e0\u5238\u4f7f\u7528\u901a\u77e5"),
    MEMEBER_UPGRADE("MEMBER", "MEMEBER_UPGRADE", "\u4f1a\u5458\u5347\u7ea7\u901a\u77e5"),
    MEMEBER_DOWNGRADE("MEMBER", "MEMEBER_DOWNGRADE", "\u4f1a\u5458\u964d\u7ea7\u901a\u77e5"),
    INTEGRAL_ADD("INTEGRAL", "INTEGRAL_ADD", "\u79ef\u5206\u5165\u8d26\u901a\u77e5"),
    ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE("ACTIVITY", "ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE", "\u6d3b\u52a8\u5f00\u59cb\u901a\u77e5"),
    MEMBER_SIGN("ACTIVITY", "MEMBER_SIGN", "\u4f1a\u5458\u7b7e\u5230\u63d0\u9192");

    private String businessType;
    private String templateType;
    private String templateName;

    private WeChatSubscribeTypeEnum(String businessType, String templateType, String templateName) {
        this.businessType = businessType;
        this.templateType = templateType;
        this.templateName = templateName;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public static List<String> getTemplateTypeList() {
        return Arrays.stream(WeChatSubscribeTypeEnum.values()).map(WeChatSubscribeTypeEnum::getTemplateType).collect(Collectors.toList());
    }

    public static boolean canSendSubscribeType(String templateType) {
        if (MEMEBER_UPGRADE.getTemplateType().equals(templateType) || MEMEBER_DOWNGRADE.getTemplateType().equals(templateType)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

