package com.bizvane.messagefacade.models.vo;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.messagefacade.enums.MsgTemplateType;

/**
 * Created by yunjie.tian on 2018/7/16.
 */
public class GenMessageVO implements Serializable{

    private static final long serialVersionUID = 1L;
     
    //公共必填字段
    @ApiModelProperty(value = "企业id", name = "sysCompanyId")
    private Long sysCompanyId;
    
    @ApiModelProperty(value = "所属品牌id", name = "sysBrandId", required = false, example = "")
    private Long sysBrandId;
    
    @ApiModelProperty(value = "会员code", name = "memberCode", required = false, example = "")
    private String memberCode;
    
    @ApiModelProperty(value = "模板类型在枚举类：MsgTemplateType", name = "例如储值余额变动模板消息提醒填：templateType=CHU_ZHI_GEN_WXTEMPLATE_MESSAGE", required = false, example = "")
    private String templateType;
    
    @ApiModelProperty(value = "模板内容", name = "messagejo", required = false, example = "")
    private JSONObject messagejo;
    
    @ApiModelProperty(value = "电话号码，多个逗号隔开", name = "messagejo", required = false, example = "")
    private String phoneStr;
    @ApiModelProperty(value = "true就发送短信", name = "messagejo", required = false, example = "")
    private Boolean sendSMS;
    @ApiModelProperty(value = "true就发送微信", name = "messagejo", required = false, example = "")
    private Boolean sendWeChat; 
    
    //公共必填字段 tu
    
//    模板内容例子
//    JSONObject messagejo = new JSONObject();
//    messagejo.put("first","您有一笔余额支出。/您完成了一笔充值业务。");//
//    
//    messagejo.put("keyword1","账户余额变动");//  变动类型：账户余额变动
//    messagejo.put("keyword2","200");//变动金额：200
//    messagejo.put("keyword3","2000");// 剩余余额：2000
//    messagejo.put("keyword4","港汇恒隆广场店");// 交易门店：港汇恒隆广场店
//    messagejo.put("keyword5","2019-03-05");// 变动日期：2019－03－05
//    
//    messagejo.put("remark","感谢您的支持");
//    messagejo.put("url","pages/entry/main");// 小程序跳转页面地址(具体根据模板要求，前端要)
    
    //如果不是会员，是粉丝情况传openId
    @ApiModelProperty(value = "微信openId", name = "openId", required = false, example = "")
    private String openId;
    
	public String getPhoneStr() {
		return phoneStr;
	}

	public void setPhoneStr(String phoneStr) {
		this.phoneStr = phoneStr;
	}

	public Long getSysCompanyId() {
		return sysCompanyId;
	}

	public void setSysCompanyId(Long sysCompanyId) {
		this.sysCompanyId = sysCompanyId;
	}

	public Long getSysBrandId() {
		return sysBrandId;
	}

	public void setSysBrandId(Long sysBrandId) {
		this.sysBrandId = sysBrandId;
	}

	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public String getOpenId() {
		return openId;
	}

	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public String getTemplateType() {
		return templateType;
	}

	public void setTemplateType(String templateType) {
		this.templateType = templateType;
	}

	public JSONObject getMessagejo() {
		return messagejo;
	}

	public void setMessagejo(JSONObject messagejo) {
		this.messagejo = messagejo;
	}
   
    
    
    
    
}
