package com.bizvane.messagefacade.interfaces;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.messagebase.common.constants.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author yuantq
 * @date 2023/11/27
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/messageParamConvert")
@Api(value = "消息通知会员基础字段转换", tags = {"消息通知会员基础字段转换"})
public interface MessageParamConvertServiceFeign {

    @ApiOperation(value = "短信活动消费模板替换会员基础字段")
    @PostMapping("/smsTemplateParamConvert")
    ResponseData<String> smsTemplateParamConvert(@RequestBody JSONObject jsonObject);

    /**
     *
     * @param jsonObject 必传参数:sysBrandId  sysCompanyId  memberCodeList
     *                      例子:{"brandId":1,"sysCompanyId":1,"memberCodeList":["111"]}
     * @return
     */
    @ApiOperation(value = "批量会员模板替换会员基础字段")
    @PostMapping("/batchTemplateParamConvert")
    ResponseData<List<JSONObject>> batchTemplateParamConvert(@RequestBody JSONObject jsonObject);

}
