package com.bizvane.messagefacade.models.vo.subscribe;

import com.alibaba.fastjson.annotation.JSONField;
import com.bizvane.messagefacade.models.vo.MemberMessageVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author yuantq
 * @date 2022/8/22
 */
@Data
public class RechargeBalanceUseMessageVO extends MemberMessageVO {


    @JSONField(name = "FIELD_RECHARGE_CARD_NO")
    @JsonProperty(value = "FIELD_RECHARGE_CARD_NO")
    private String FIELD_RECHARGE_CARD_NO;

    @JSONField(name = "FIELD_CONSUMPTION_AMOUNT")
    @JsonProperty(value = "FIELD_CONSUMPTION_AMOUNT")
    private Double FIELD_CONSUMPTION_AMOUNT;

    @JSONField(name = "FIELD_RECHARGE_BALANCE")
    @JsonProperty(value = "FIELD_RECHARGE_BALANCE")
    private Double FIELD_RECHARGE_BALANCE;

    /**
     * 此处时间
     */
    @DateTimeFormat(pattern = "yyyy年MM月dd日 HH:mm:ss")
    @JsonFormat(pattern = "yyyy年MM月dd日 HH:mm:ss", timezone = "GMT+8")
    @JSONField(name = "FIELD_CONSUMPTION_TIME")
    @JsonProperty(value = "FIELD_CONSUMPTION_TIME")
    private Date FIELD_CONSUMPTION_TIME;

    @JSONField(name = "FIELD_TEXT")
    @JsonProperty(value = "FIELD_TEXT")
    private String FIELD_TEXT;

}
