package com.bizvane.messagefacade.interfaces;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.messagefacade.models.vo.WechatEnterpriseMessageVO;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * Created by yunjie.tian on 2019/1/11.
 */
@FeignClient(value="${feign.client.message.name}",path="${feign.client.message.path}/wechatCompany")
@Api(value = "企业微信模板消息",tags = {"企业微信模板消息"})
public interface WechatCompanyServiceFeign {

    /**
     * 离线消息
     * @return
     */
    @RequestMapping(value = "/offlineInfo", method = RequestMethod.POST)
    @ResponseBody
    public Result<String> offlineInfo(@RequestBody WechatEnterpriseMessageVO requestVO);

}
