package com.bizvane.messagefacade.enums;

public enum WechatAppletSubscribeTopicEnum {

    SUBSCRIBE_MSG_POPUP_EVENT("subscribe_msg_popup_event",WechatAppletSubscribeTopicEnum.TOPIC_NAME,WechatAppletSubscribeTopicEnum.TAG_NAME_POPUP),
    SUBSCRIBE_MSG_CHANGE_EVENT("subscribe_msg_change_event",WechatAppletSubscribeTopicEnum.TOPIC_NAME,WechatAppletSubscribeTopicEnum.TAG_NAME_CHANGE),
    SUBSCRIBE_MSG_SENT_EVENT("subscribe_msg_sent_event",WechatAppletSubscribeTopicEnum.TOPIC_NAME,WechatAppletSubscribeTopicEnum.TAG_NAME_SENT);
    ;

    private String event;

    private String topic;

    private String tag;

    private final static String TOPIC_NAME = "wechat_applet_subscribe";
    private final static String TAG_NAME_POPUP = "subscribe_msg_popup_event";
    private final static String TAG_NAME_CHANGE = "subscribe_msg_change_event";
    private final static String TAG_NAME_SENT = "subscribe_msg_sent_event";

    WechatAppletSubscribeTopicEnum(String event, String topic, String tag) {
        this.event = event;
        this.topic = topic;
        this.tag = tag;
    }

    public String getEvent() {
        return event;
    }

    public String getTopic() {
        return topic;
    }

    public String getTag() {
        return tag;
    }
}
