package com.bizvane.messagefacade.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 微信图文消息数据源类型枚举
 * @author huangxinliu
 * @date: 2021/1/15 12:00
 */
@AllArgsConstructor
@Getter
public enum MsgWxTuwenDataSourceTypeEnum {

    MONGODB("mongodb", "mongodb"),
    MYSQL("mysql", "mysql"),
    ;

    private String code;
    private String msg;

    public static String getMsg(String code){
        for (MsgWxTuwenSendStatusEnum c: MsgWxTuwenSendStatusEnum.values()){
            if(c.getCode().equals(code)){
                return c.getMsg();
            }
        }
        return null;
    }

}
