package com.bizvane.messagefacade.interfaces;

import com.bizvane.messagefacade.models.dto.WxMsgConformSendRulesMemberDto;
import com.bizvane.messagefacade.models.vo.WXTemplateSendRuleResultVO;
import com.bizvane.messagefacade.models.vo.WxMsgConformSendRulesMemberSearchVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 微信模板消息发送匹配规则
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/wxTempSendRule")
@Api(value = "微信模板消息发送匹配规则", tags = {"微信模板消息发送匹配规则"})
public interface WXTemplateSendRuleServiceFeign {

	/**
	 * 根据企业id查询消息发送匹配规则
	 *
	 * @param  sysCompanyId
	 * @return
	 */
	@ApiOperation(value = "根据企业id查询消息发送匹配规则")
	@RequestMapping(value = "/getWxTemplateSendRule", method = RequestMethod.GET)
	@ResponseBody
	ResponseData<WXTemplateSendRuleResultVO> wxTemplateSendRule(@RequestParam Long sysCompanyId);

	/**
	 * 根据企业id,会员groupMemberCode,品牌集合查询符合消息发送规则的品牌信息
	 * @param wxMsgConformSendRulesMemberSearchVo
	 * @return
	 */
	@ApiOperation(value = "根据企业id查询消息发送匹配规则")
	@RequestMapping(value = "/getWxMsgConformSendRulesMemberDto", method = RequestMethod.POST)
	@ResponseBody
	ResponseData<WxMsgConformSendRulesMemberDto> getWxMsgConformSendRulesMemberDto(@RequestBody WxMsgConformSendRulesMemberSearchVo wxMsgConformSendRulesMemberSearchVo);


}
