package com.bizvane.messagefacade.enums.subscribefield;

import com.bizvane.messagefacade.enums.WeChatSubscribeFieldEnum;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yuantq
 * @date 2022/8/23
 */
public enum RechargeBalanceUseFieldEnum {

    FIELD_1("CONSUME_GEN_WXTEMPLATE_MESSAGE", WeChatSubscribeFieldEnum.RECHARGE_CARD_NO, "FIELD_RECHARGE_CARD_NO", Boolean.TRUE),
    FIELD_2("CONSUME_GEN_WXTEMPLATE_MESSAGE", WeChatSubscribeFieldEnum.CONSUMPTION_AMOUNT, "FIELD_CONSUMPTION_AMOUNT", Boolean.TRUE),
    FIELD_3("CONSUME_GEN_WXTEMPLATE_MESSAGE", WeChatSubscribeFieldEnum.RECHARGE_BALANCE, "FIELD_RECHARGE_BALANCE", Boolean.TRUE),
    FIELD_4("CONSUME_GEN_WXTEMPLATE_MESSAGE", WeChatSubscribeFieldEnum.CONSUMPTION_TIME, "FIELD_CONSUMPTION_TIME", Boolean.TRUE),
    FIELD_5("CONSUME_GEN_WXTEMPLATE_MESSAGE", WeChatSubscribeFieldEnum.TEXT, "FIELD_TEXT");

    private String menuCode;

    private WeChatSubscribeFieldEnum weChatSubscribeFieldEnum;

    private String jsonField;

    private Boolean mustNotNull = Boolean.FALSE;

    RechargeBalanceUseFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
    }

    RechargeBalanceUseFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField, Boolean mustNotNull) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
        this.mustNotNull = mustNotNull;
    }

    public String getMenuCode() {
        return menuCode;
    }

    public WeChatSubscribeFieldEnum getWeChatSubscribeFieldEnum() {
        return weChatSubscribeFieldEnum;
    }

    public String getJsonField() {
        return jsonField;
    }

    public Boolean getMustNotNull() {
        return mustNotNull;
    }

    public static List<String> mustFieldList() {
        return Arrays.stream(RechargeBalanceUseFieldEnum.values()).filter(e -> e.getMustNotNull()).map(RechargeBalanceUseFieldEnum::getJsonField).collect(Collectors.toList());
    }

    public static Map<String, String> codeConvertJsonFieldMap() {
        return Arrays.stream(RechargeBalanceUseFieldEnum.values()).collect(Collectors.toMap(e -> e.getWeChatSubscribeFieldEnum().getFieldCode(), RechargeBalanceUseFieldEnum::getJsonField, (a, b) -> b));
    }

}
