/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.email.service.impl;

import com.bizvane.email.service.SendEmailService;
import com.bizvane.messagebase.mq.body.EmailMessageVO;
import com.sun.mail.util.MailSSLSocketFactory;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class SendEmailServiceImpl
implements SendEmailService {
    public void sendEmail(EmailMessageVO emailMessageVO) throws MessagingException {
        JavaMailSenderImpl send = new JavaMailSenderImpl();
        Properties prop = new Properties();
        prop.setProperty("mail.transport.protocol", emailMessageVO.getProtocol());
        prop.setProperty("mail.host", emailMessageVO.getHost());
        prop.setProperty("mail.smtp.port", emailMessageVO.getPort());
        prop.setProperty("mail.smtp.auth", "true");
        try {
            MailSSLSocketFactory sf = new MailSSLSocketFactory();
            sf.setTrustAllHosts(true);
            prop.put("mail.smtp.ssl.enable", "true");
            prop.put("mail.smtp.ssl.socketFactory", sf);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        send.setUsername(emailMessageVO.getEmailName());
        send.setPassword(emailMessageVO.getEmailPassword());
        send.setJavaMailProperties(prop);
        MimeMessage msg = send.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(msg, "UTF-8");
        helper.setFrom(emailMessageVO.getFrom());
        helper.setTo(emailMessageVO.getRecipient());
        helper.setSentDate(new Date());
        helper.setSubject(emailMessageVO.getSubject());
        String content = emailMessageVO.getContent();
        helper.setText(content, true);
        send.send(msg);
    }
}

