/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.email.rocketmq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.bizvane.email.service.SendEmailService;
import com.bizvane.messagebase.mq.body.EmailMessageVO;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="message_send_email")
public class EmailConsumerListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(EmailConsumerListener.class);
    @Autowired
    private SendEmailService sendEmailService;

    public void onMessage(ConsumerMessage<String> message) {
        String body = (String)message.getMessage();
        log.info("EmailConsumerListener poll one record : {}", (Object)body);
        String bodyJson = JSON.parse((String)body).toString();
        EmailMessageVO emailMessageVO = (EmailMessageVO)JSON.parseObject((String)bodyJson, EmailMessageVO.class);
        try {
            this.sendEmailService.sendEmail(emailMessageVO);
        }
        catch (MessagingException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getCause() == null ? e.getMessage() : e.getCause().getMessage());
        }
        log.info("EmailConsumerListener consume success.");
    }
}

