/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.domain.util;

import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;

public class ResponseUtil {
    public static ResponseData fail(String message) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(message);
        return responseData;
    }

    public static ResponseData fail(String message, Object data) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(message);
        responseData.setData(data);
        return responseData;
    }

    public static ResponseData fail() {
        return ResponseUtil.fail(SysResponseEnum.FAILED.getMessage());
    }

    public static ResponseData success(Object result) {
        return new ResponseData(result);
    }

    public static ResponseData success() {
        return new ResponseData();
    }

    public static ResponseData success(Object result, String message) {
        return new ResponseData(message, result);
    }

    public static boolean isSuccess(ResponseData responseData) {
        return responseData.getCode() == SysResponseEnum.SUCCESS.getCode();
    }

    public static boolean isFail(ResponseData responseData) {
        return !ResponseUtil.isSuccess(responseData);
    }

    public static ResponseData copy(ResponseData responseData) {
        ResponseData copyResponseData = new ResponseData();
        copyResponseData.setCode(responseData.getCode());
        copyResponseData.setMessage(responseData.getMessage());
        return copyResponseData;
    }

    public static ResponseData of(SysResponseEnum sysResponseEnum) {
        return ResponseUtil.of(sysResponseEnum, null);
    }

    public static ResponseData of(SysResponseEnum sysResponseEnum, Object data) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(sysResponseEnum.getCode());
        responseData.setMessage(sysResponseEnum.getMessage());
        responseData.setData(data);
        return responseData;
    }

    public static ResponseData ofArgs(SysResponseEnum sysResponseEnum, Object ... args) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(sysResponseEnum.getCode());
        responseData.setMessage(String.format(sysResponseEnum.getMessage(), args));
        return responseData;
    }

    public static ResponseData ofMessage(SysResponseEnum sysResponseEnum, String message) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(sysResponseEnum.getCode());
        responseData.setMessage(message);
        return responseData;
    }
}

