/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.domain.service.component;

import com.alibaba.fastjson.JSON;
import com.bizvane.message.domain.consts.WeChatConst;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.feign.vo.wechat.WeChatGetMessageTemplateFieldVO;
import com.bizvane.message.feign.vo.wechat.WeChatGetMessageTemplateVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechat.feign.feign.WechatSendMsgRpcFeign;
import com.bizvane.wechat.feign.model.req.WxSendSubscribeMsgReq;
import com.bizvane.wechat.feign.model.req.base.WxBaseAppIdReq;
import com.bizvane.wechat.feign.model.rsp.WxTemplateInfoRsp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class WechatComponent {
    @Autowired
    private WechatSendMsgRpcFeign wechatSendMsgRpcFeign;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Value(value="${base.appId:123456}")
    private String appId;

    public ResponseData<Boolean> sendSubscribeMsg(WxSendSubscribeMsgReq req) {
        req.setAppid(this.appId);
        return this.wechatSendMsgRpcFeign.sendSubscribeMsg(req);
    }

    public ResponseData<List<WeChatGetMessageTemplateVO>> getMessageTemplateList() {
        String result = (String)this.redisTemplate.opsForValue().get((Object)"wxaapi:newtmpl:gettemplate");
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return ResponseUtil.success(JSON.parseArray((String)result, WeChatGetMessageTemplateVO.class), "\u83b7\u53d6\u4e2a\u4eba\u6a21\u677f\u5217\u8868ByRedis");
        }
        WxBaseAppIdReq wxBaseAppIdReq = new WxBaseAppIdReq();
        wxBaseAppIdReq.setAppid(this.appId);
        ResponseData responseVO = this.wechatSendMsgRpcFeign.getTemplateList(wxBaseAppIdReq);
        if (responseVO == null || responseVO.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return ResponseUtil.copy(responseVO);
        }
        ArrayList<WeChatGetMessageTemplateVO> responseVOList = this.convertWeChatGetMessageTemplateVOS((List)responseVO.getData());
        if (CollectionUtils.isNotEmpty(responseVOList)) {
            this.redisTemplate.opsForValue().set((Object)"wxaapi:newtmpl:gettemplate", (Object)JSON.toJSONString(responseVOList), 3600L, WeChatConst.GET_MESSAGE_TEMPLATE_LIST_REDIS_TIME_UNIT);
        }
        return ResponseUtil.success(responseVOList, "\u83b7\u53d6\u4e2a\u4eba\u6a21\u677f\u5217\u8868ByInterface");
    }

    private ArrayList<WeChatGetMessageTemplateVO> convertWeChatGetMessageTemplateVOS(List<WxTemplateInfoRsp> wechatDataList) {
        ArrayList<WeChatGetMessageTemplateVO> responseVOList = new ArrayList<WeChatGetMessageTemplateVO>();
        for (WxTemplateInfoRsp dataJson : wechatDataList) {
            WeChatGetMessageTemplateVO weChatGetMessageTemplateVO = new WeChatGetMessageTemplateVO();
            weChatGetMessageTemplateVO.setWxTempId(dataJson.getPriTmplId());
            weChatGetMessageTemplateVO.setWxTempTitle(dataJson.getTitle());
            weChatGetMessageTemplateVO.setWxTempContent(dataJson.getContent());
            weChatGetMessageTemplateVO.setExample(dataJson.getExample());
            weChatGetMessageTemplateVO.setWxTempType(dataJson.getType());
            if (StringUtils.isNotBlank((CharSequence)weChatGetMessageTemplateVO.getWxTempContent())) {
                Object[] nameValueArray = weChatGetMessageTemplateVO.getWxTempContent().split("\\n");
                if (ArrayUtils.isEmpty((Object[])nameValueArray)) {
                    throw new BizException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6a21\u677f\u5b57\u6bb5\u89e3\u6790\u5931\u8d25");
                }
                ArrayList<WeChatGetMessageTemplateFieldVO> fieldList = new ArrayList<WeChatGetMessageTemplateFieldVO>();
                for (Object nameValueString : nameValueArray) {
                    String[] nameValueSplit = ((String)nameValueString).split(":");
                    if (ArrayUtils.getLength((Object)nameValueSplit) != 2) {
                        throw new BizException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6a21\u677f\u5b57\u6bb5\u89e3\u6790nameValue\u5931\u8d25");
                    }
                    String name = nameValueSplit[0];
                    String value = nameValueSplit[1].replace("{", "").replace("}", "").replace(".DATA", "");
                    fieldList.add(new WeChatGetMessageTemplateFieldVO(name, value));
                }
                weChatGetMessageTemplateVO.setFieldList(fieldList);
            }
            responseVOList.add(weChatGetMessageTemplateVO);
        }
        return responseVOList;
    }
}

