/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.domain.service.component;

import com.alibaba.fastjson.JSON;
import com.bizvane.members.feign.model.vo.MbrMembersDetailVO;
import com.bizvane.members.feign.model.vo.MbrMembersVO;
import com.bizvane.members.feign.service.MbrMemberFeign;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MemberComponent {
    private static final Logger log = LoggerFactory.getLogger(MemberComponent.class);
    @Autowired
    private MbrMemberFeign memberFeign;

    public ResponseData<MbrMembersDetailVO> detailByMemberCode(String memberCode) {
        return this.memberFeign.detail(memberCode);
    }

    public MbrMembersDetailVO detailDataByMemberCode(String memberCode) {
        ResponseData responseData = this.memberFeign.detail(memberCode);
        log.info("memberFeign.detail:{}", (Object)JSON.toJSONString((Object)responseData));
        if (ResponseUtil.isFail(responseData)) {
            throw new BizException(String.format("\u4f1a\u5458\u4fe1\u606f\u67e5\u8be2\u5931\u8d25:[%s]", responseData.getMessage()));
        }
        if (responseData.getData() == null) {
            throw new BizException(SysResponseEnum.MEMBER_NOT_FOUND.getCode(), SysResponseEnum.MEMBER_NOT_FOUND.getMessage());
        }
        return (MbrMembersDetailVO)responseData.getData();
    }

    public MbrMembersVO detailDataByPhoneEncrypt(String phoneEncrypt) {
        ResponseData responseData = this.memberFeign.getMemberByPhone(phoneEncrypt);
        log.info("memberFeign.detail:{}", (Object)JSON.toJSONString((Object)responseData));
        if (ResponseUtil.isFail(responseData)) {
            throw new BizException(String.format("\u4f1a\u5458\u4fe1\u606f\u67e5\u8be2\u5931\u8d25:[%s]", responseData.getMessage()));
        }
        return (MbrMembersVO)responseData.getData();
    }
}

