/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.domain.enums.msg;

import com.bizvane.message.domain.consts.BusinessConts;
import com.bizvane.message.domain.enums.msg.MsgBusinessTypeEnum;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public enum MsgTemplateTypeEnum {
    FLIGHT_TRAVEL("FLIGHT_TRAVEL", "\u51fa\u884c\u63d0\u9192", MsgBusinessTypeEnum.FLIGHT),
    FLIGHT_BOARDING("FLIGHT_BOARDING", "\u767b\u673a\u63d0\u9192", MsgBusinessTypeEnum.FLIGHT),
    FLIGHT_DELAY("FLIGHT_DELAY", "\u822a\u73ed\u5ef6\u8bef\u63d0\u9192", MsgBusinessTypeEnum.FLIGHT),
    FLIGHT_GATE_CHANGE("FLIGHT_GATE_CHANGE", "\u767b\u673a\u53e3\u53d8\u66f4\u63d0\u9192", MsgBusinessTypeEnum.FLIGHT),
    FLIGHT_LUGGAGE_CHANGE("FLIGHT_LUGGAGE_CHANGE", "\u884c\u674e\u8f6c\u76d8\u53d8\u66f4\u63d0\u9192", MsgBusinessTypeEnum.FLIGHT),
    SERVICE_EVALUATION("SERVICE_EVALUATION", "\u670d\u52a1\u8bc4\u4ef7\u63d0\u9192", MsgBusinessTypeEnum.SERVICE, BusinessConts.PREVENT_DISTURBANCE),
    MEMBER_REGISTRATION("MEMBER_REGISTRATION", "\u4f1a\u5458\u6ce8\u518c\u63d0\u9192", MsgBusinessTypeEnum.MEMBER, BusinessConts.PREVENT_DISTURBANCE),
    INTEGRAL_RECEIVE("INTEGRAL_RECEIVE", "\u79ef\u5206\u5165\u8d26\u63d0\u9192", MsgBusinessTypeEnum.INTEGRAL, BusinessConts.PREVENT_DISTURBANCE),
    INTEGRAL_USE("INTEGRAL_USE", "\u79ef\u5206\u4f7f\u7528\u63d0\u9192", MsgBusinessTypeEnum.INTEGRAL, BusinessConts.PREVENT_DISTURBANCE),
    INTEGRAL_EXPIRE("INTEGRAL_EXPIRE", "\u79ef\u5206\u8fc7\u671f\u63d0\u9192", MsgBusinessTypeEnum.INTEGRAL, BusinessConts.PREVENT_DISTURBANCE),
    COUPON_RECEIVE("COUPON_RECEIVE", "\u5238\u5165\u8d26\u63d0\u9192", MsgBusinessTypeEnum.COUPON, BusinessConts.PREVENT_DISTURBANCE),
    COUPON_USE("COUPON_USE", "\u5238\u4f7f\u7528\u63d0\u9192", MsgBusinessTypeEnum.COUPON, BusinessConts.PREVENT_DISTURBANCE),
    COUPON_EXPIRE("COUPON_EXPIRE", "\u5238\u8fc7\u671f\u63d0\u9192", MsgBusinessTypeEnum.COUPON, BusinessConts.PREVENT_DISTURBANCE),
    ACTIVITY_WINNING("ACTIVITY_WINNING", "\u6d3b\u52a8\u4e2d\u5956\u901a\u77e5", MsgBusinessTypeEnum.ACTIVITY, BusinessConts.PREVENT_DISTURBANCE),
    ACTIVITY_SIGN("ACTIVITY_SIGN", "\u4f1a\u5458\u7b7e\u5230\u901a\u77e5", MsgBusinessTypeEnum.ACTIVITY, BusinessConts.PREVENT_DISTURBANCE),
    ACTIVITY_BEGINS("ACTIVITY_BEGINS", "\u6d3b\u52a8\u5f00\u59cb\u901a\u77e5", MsgBusinessTypeEnum.ACTIVITY, BusinessConts.PREVENT_DISTURBANCE),
    INTEGRAL_ORDER_SEND("INTEGRAL_ORDER_SEND", "\u5546\u57ce\u53d1\u8d27\u901a\u77e5", MsgBusinessTypeEnum.MALL),
    MKT_MASS_MESSAGE("MKT_MASS_MESSAGE", "\u6d88\u606f\u7fa4\u53d1", MsgBusinessTypeEnum.MKT);

    private String code;
    private String desc;
    private MsgBusinessTypeEnum businessTypeEnum;
    private boolean preventDisturbance = BusinessConts.ALLOW_DISTURBANCE;

    private MsgTemplateTypeEnum(String code, String desc, MsgBusinessTypeEnum businessTypeEnum) {
        this.code = code;
        this.desc = desc;
        this.businessTypeEnum = businessTypeEnum;
    }

    private MsgTemplateTypeEnum(String code, String desc, MsgBusinessTypeEnum businessTypeEnum, boolean preventDisturbance) {
        this.code = code;
        this.desc = desc;
        this.businessTypeEnum = businessTypeEnum;
        this.preventDisturbance = preventDisturbance;
    }

    public static boolean isCoupon(String templateType) {
        if (StringUtils.isBlank((CharSequence)templateType)) {
            return false;
        }
        return COUPON_RECEIVE.getCode().equals(templateType) || COUPON_USE.getCode().equals(templateType) || COUPON_EXPIRE.getCode().equals(templateType);
    }

    public static boolean isActivity(String templateType) {
        if (StringUtils.isBlank((CharSequence)templateType)) {
            return false;
        }
        return ACTIVITY_WINNING.getCode().equals(templateType) || ACTIVITY_SIGN.getCode().equals(templateType) || ACTIVITY_BEGINS.getCode().equals(templateType);
    }

    public static boolean isTask(String templateType) {
        if (StringUtils.isBlank((CharSequence)templateType)) {
            return false;
        }
        return ACTIVITY_WINNING.getCode().equals(templateType) || ACTIVITY_SIGN.getCode().equals(templateType) || ACTIVITY_BEGINS.getCode().equals(templateType);
    }

    public static boolean preventDisturbance(String templateType) {
        MsgTemplateTypeEnum result = Arrays.stream(MsgTemplateTypeEnum.values()).filter(msgTemplateTypeEnum -> msgTemplateTypeEnum.getCode().equals(templateType)).findFirst().orElse(null);
        return result != null ? result.isPreventDisturbance() : Boolean.FALSE.booleanValue();
    }

    public static MsgTemplateTypeEnum getByCode(String code) {
        return Arrays.stream(MsgTemplateTypeEnum.values()).filter(msgTemplateTypeEnum -> msgTemplateTypeEnum.getCode().equals(code)).findAny().orElse(null);
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public MsgBusinessTypeEnum getBusinessTypeEnum() {
        return this.businessTypeEnum;
    }

    public boolean isPreventDisturbance() {
        return this.preventDisturbance;
    }
}

