/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.listener.handler;

import com.bizvane.message.api.model.vo.sms.SmsCallBackVO;
import com.bizvane.message.api.service.RocketMQBusinessService;
import com.bizvane.message.api.service.RocketMessageHandler;
import com.bizvane.message.domain.enums.msg.MsgSmsSendStateEnum;
import com.bizvane.message.domain.model.entity.MsgSmsSentBatchPO;
import com.bizvane.message.domain.model.entity.MsgSmsSentRecordPO;
import com.bizvane.message.domain.service.IMsgSmsSentBatchService;
import com.bizvane.message.domain.service.IMsgSmsSentRecordService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MsgSmsCallBackMessageHandler
implements RocketMessageHandler<Object, SmsCallBackVO> {
    private final IMsgSmsSentBatchService msgSmsSentBatchService;
    private final IMsgSmsSentRecordService msgSmsSentRecordService;
    private final RocketMQBusinessService rocketMQBusinessService;

    @Override
    public ResponseData<SendResult> sendMQMessage(SmsCallBackVO param) {
        SendResult sendResult = this.rocketMQBusinessService.sendSmsCallBack(param);
        return ResponseUtil.success((Object)sendResult);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Object> handlerMQMessage(SmsCallBackVO smsCallBackVO) {
        MsgSmsSentBatchPO querySentBatch = this.msgSmsSentBatchService.selectByCode(smsCallBackVO.getBatchid());
        if (querySentBatch == null) {
            return ResponseUtil.fail((String)"\u77ed\u4fe1\u6d88\u606f\u6279\u6b21\u4e0d\u5b58\u5728!");
        }
        MsgSmsSentRecordPO querySentRecord = this.msgSmsSentRecordService.selectOneByBatchCodeAndPhone(smsCallBackVO.getBatchid(), smsCallBackVO.getPhone());
        if (querySentRecord == null) {
            return ResponseUtil.success(null, (String)"\u77ed\u4fe1\u53d1\u9001\u8bb0\u5f55\u4e0d\u5b58\u5728!");
        }
        if (MsgSmsSendStateEnum.SUCCESS.getCode().compareTo(querySentRecord.getSendState()) == 0) {
            this.smsSentSuccess(querySentBatch, querySentRecord);
        } else {
            this.smsSentFail(querySentBatch, querySentRecord, smsCallBackVO);
        }
        return ResponseUtil.success();
    }

    private void smsSentSuccess(MsgSmsSentBatchPO querySentBatch, MsgSmsSentRecordPO querySentRecord) {
        this.msgSmsSentRecordService.updateSendStatusByCode("\u6210\u529f", MsgSmsSendStateEnum.SUCCESS.getCode(), null, querySentRecord.getMsgSmsSentRecordCode());
        this.msgSmsSentBatchService.updateSuccessCountByCode(querySentBatch.getMsgSmsSentBatchCode(), Integer.valueOf(1));
    }

    private void smsSentFail(MsgSmsSentBatchPO querySentBatch, MsgSmsSentRecordPO querySentRecord, SmsCallBackVO smsCallBackVO) {
        String sendResult = this.convertSendResult(smsCallBackVO);
        String failDetail = this.getStatusDesc(smsCallBackVO, sendResult);
        this.msgSmsSentRecordService.updateSendStatusByCode(sendResult, MsgSmsSendStateEnum.FAIL.getCode(), failDetail, querySentRecord.getMsgSmsSentRecordCode());
        this.msgSmsSentBatchService.updateFailCountByCode(querySentBatch.getMsgSmsSentBatchCode(), Integer.valueOf(1));
    }

    private String convertSendResult(SmsCallBackVO smsCallBackVO) {
        switch (smsCallBackVO.getStatus()) {
            case "UNKNOWN": {
                return "\u672a\u77e5\u77ed\u4fe1\u72b6\u6001";
            }
            case "REJECTD": {
                return "\u77ed\u4fe1\u88ab\u77ed\u4fe1\u4e2d\u5fc3\u62d2\u7edd";
            }
            case "MBBLACK": {
                return "\u76ee\u7684\u53f7\u7801\u662f\u9ed1\u540d\u5355\u53f7\u7801";
            }
            case "REJECT": {
                return "\u5ba1\u6838\u9a73\u56de";
            }
            case "FAIL": {
                return "\u7f51\u5173\u5185\u90e8\u72b6\u6001\u5931\u8d25";
            }
        }
        return "\u672a\u5339\u914d\u7684\u72b6\u6001\u7801";
    }

    private String getStatusDesc(SmsCallBackVO smsCallBackVO, String defaultDesc) {
        String statusDesc = smsCallBackVO.getStatusDesc();
        if (StringUtils.isBlank((CharSequence)statusDesc) || "\u672a\u77e5\u9519\u8bef".equals(statusDesc)) {
            return defaultDesc;
        }
        return statusDesc;
    }

    public MsgSmsCallBackMessageHandler(IMsgSmsSentBatchService msgSmsSentBatchService, IMsgSmsSentRecordService msgSmsSentRecordService, RocketMQBusinessService rocketMQBusinessService) {
        this.msgSmsSentBatchService = msgSmsSentBatchService;
        this.msgSmsSentRecordService = msgSmsSentRecordService;
        this.rocketMQBusinessService = rocketMQBusinessService;
    }
}

