/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.api.service.RocketMQBusinessService;
import com.bizvane.message.api.service.SubscribeResendService;
import com.bizvane.message.domain.enums.WeChatSubscribeTopicEnum;
import com.bizvane.message.domain.model.entity.MsgSendtimePO;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.feign.vo.msg.MsgBodyResponseVO;
import com.bizvane.message.feign.vo.msg.MsgBodyWrapperVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeActivityBeginsBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeActivitySignBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeActivityWinningBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeCouponExpireBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeCouponReceiveBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeCouponUseBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeFlightBoardingBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeFlightDelayBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeFlightGateChangeBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeFlightLuggageChangeBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeFlightTravelBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeIntegralExpireBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeIntegralOrderSendBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeIntegralReceiveBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeIntegralUseBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeMassTaskBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeMemberRegistrationBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeServiceEvaluationBodyVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.springframework.stereotype.Service;

@Service
public class SubscribeResendServiceImpl
implements SubscribeResendService {
    private final RocketMQBusinessService rocketMQBusinessService;

    @Override
    public ResponseData<MsgBodyResponseVO> flightTravel(MsgBodyWrapperVO<SubscribeFlightTravelBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.FLIGHT_TRAVEL, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> flightBoarding(MsgBodyWrapperVO<SubscribeFlightBoardingBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.FLIGHT_BOARDING, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> flightDelay(MsgBodyWrapperVO<SubscribeFlightDelayBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.FLIGHT_DELAY, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> flightGateChange(MsgBodyWrapperVO<SubscribeFlightGateChangeBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.FLIGHT_GATE_CHANGE, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> flightLuggageChange(MsgBodyWrapperVO<SubscribeFlightLuggageChangeBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.FLIGHT_LUGGAGE_CHANGE, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> serviceEvaluation(MsgBodyWrapperVO<SubscribeServiceEvaluationBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.SERVICE_EVALUATION, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> memberRegistration(MsgBodyWrapperVO<SubscribeMemberRegistrationBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.MEMBER_REGISTRATION, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> integralReceive(MsgBodyWrapperVO<SubscribeIntegralReceiveBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.INTEGRAL_RECEIVE, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> integralUse(MsgBodyWrapperVO<SubscribeIntegralUseBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.INTEGRAL_USE, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> integralExpire(MsgBodyWrapperVO<SubscribeIntegralExpireBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.INTEGRAL_EXPIRE, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> couponReceive(MsgBodyWrapperVO<SubscribeCouponReceiveBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.COUPON_RECEIVE, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> couponUse(MsgBodyWrapperVO<SubscribeCouponUseBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.COUPON_USE, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> couponExpire(MsgBodyWrapperVO<SubscribeCouponExpireBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.COUPON_EXPIRE, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> activityWinning(MsgBodyWrapperVO<SubscribeActivityWinningBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.ACTIVITY_WINNING, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> activitySign(MsgBodyWrapperVO<SubscribeActivitySignBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.ACTIVITY_SIGN, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> activityBegins(MsgBodyWrapperVO<SubscribeActivityBeginsBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.ACTIVITY_BEGINS, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> integralOrderSend(MsgBodyWrapperVO<SubscribeIntegralOrderSendBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.INTEGRAL_ORDER_SEND, inSendTime);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> massTask(MsgBodyWrapperVO<SubscribeMassTaskBodyVO> subscribeWrapperVO, MsgSendtimePO inSendTime) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.MKT_MASS_MESSAGE, inSendTime);
    }

    private ResponseData<MsgBodyResponseVO> execute(MsgBodyWrapperVO subscribeWrapperVO, WeChatSubscribeTopicEnum weChatSubscribeTopicEnum, MsgSendtimePO inSendTime) {
        SendResult sendResult = this.rocketMQBusinessService.sendWechatSubscribeResend(JSONObject.toJSONString((Object)subscribeWrapperVO), weChatSubscribeTopicEnum, inSendTime);
        MsgBodyResponseVO msgBodyResponseVO = new MsgBodyResponseVO();
        if (sendResult.getSendStatus() != SendStatus.SEND_OK) {
            return ResponseUtil.fail((String)sendResult.getSendStatus().name());
        }
        msgBodyResponseVO.setMsgId(sendResult.getMsgId());
        return ResponseUtil.success((Object)msgBodyResponseVO);
    }

    public SubscribeResendServiceImpl(RocketMQBusinessService rocketMQBusinessService) {
        this.rocketMQBusinessService = rocketMQBusinessService;
    }
}

