/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.controller;

import com.bizvane.message.api.model.dto.template.wxsubscribe.WeChatMiniProTempEditStatusRequestParam;
import com.bizvane.message.api.model.dto.template.wxsubscribe.WeChatMiniProTempListRequestParam;
import com.bizvane.message.api.model.dto.template.wxsubscribe.WeChatMiniProTempListResponseVO;
import com.bizvane.message.api.model.vo.template.wxmini.MsgWxMiniProTempPlaceholderRequestVO;
import com.bizvane.message.api.model.vo.template.wxmini.MsgWxMiniProTempPlaceholderResponseVO;
import com.bizvane.message.api.model.vo.template.wxmini.WeChatMiniProTempDetailEditRequestVO;
import com.bizvane.message.api.model.vo.template.wxmini.WeChatMiniProTempDetailRequestVO;
import com.bizvane.message.api.model.vo.template.wxmini.WeChatMiniProTempDetailResponseVO;
import com.bizvane.message.api.service.MsgWeChatMiniProTemplateService;
import com.bizvane.message.api.util.AssertUtil;
import com.bizvane.message.feign.api.MsgWeChatMiniProTemplateFeign;
import com.bizvane.message.feign.enums.msg.MsgTemplateTypeEnum;
import com.bizvane.message.feign.vo.OptUserVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempDetailRequestVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempDetailResponseVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempPlaceholderRelDetailRequestVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempPlaceholderRelDetailResponseVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempUpdateRequestVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempUpdateResponseVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempUpdateStatusRequestVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempUpdateStatusResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/weChatMiniProTemplate"})
@Api(value="\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f", tags={"\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f"})
public class MsgWeChatMiniProTemplateController
implements MsgWeChatMiniProTemplateFeign {
    private final MsgWeChatMiniProTemplateService msgWeChatMiniProTemplateService;

    @ApiOperation(value="\u67e5\u8be2\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f(\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3)", notes="\u67e5\u8be2\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f", tags={"\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f\u6a21\u677f\u67e5\u8be2"}, httpMethod="POST")
    @PostMapping(value={"getWeChatMiniProTemplateList"})
    public ResponseData<List<WeChatMiniProTempListResponseVO>> getWeChatMiniProTemplateList(@RequestBody WeChatMiniProTempListRequestParam requestParam) {
        return this.msgWeChatMiniProTemplateService.getWeChatMiniProTemplateFromWechat(requestParam);
    }

    @PostMapping(value={"/getSingleTemplate"})
    public ResponseData<WeChatMiniProTempDetailResponseVO> getSingleTemplate(@RequestBody WeChatMiniProTempDetailRequestVO requestVO) {
        return this.msgWeChatMiniProTemplateService.getSingleTemplate(requestVO);
    }

    @PostMapping(value={"/saveOrUpdateTemplate"})
    public ResponseData saveOrUpdateTemplate(@RequestBody WeChatMiniProTempDetailEditRequestVO requestVO) {
        return this.msgWeChatMiniProTemplateService.saveOrUpdateTemplate(requestVO);
    }

    @PostMapping(value={"updateTemplateOpenJudge"})
    @ApiOperation(value="\u4fee\u6539\u8ba2\u9605\u6d88\u606f\u72b6\u6001", notes="\u4fee\u6539\u8ba2\u9605\u6d88\u606f\u72b6\u6001", httpMethod="POST")
    public ResponseData<Boolean> updateSceneOpenJudge(@RequestBody WeChatMiniProTempEditStatusRequestParam requestParam) {
        return this.msgWeChatMiniProTemplateService.updateSceneOpenJudge(requestParam);
    }

    @PostMapping(value={"findPlaceHolderByTemplateType"})
    public ResponseData<List<MsgWxMiniProTempPlaceholderResponseVO>> findPlaceHolderByTemplateType(@RequestBody MsgWxMiniProTempPlaceholderRequestVO requestParam) {
        return this.msgWeChatMiniProTemplateService.findPlaceHolderByTemplateType(requestParam);
    }

    public ResponseData<List<MsgWxMiniProTempPlaceholderRelDetailResponseVO>> listPlaceholderRel(@RequestBody MsgWxMiniProTempPlaceholderRelDetailRequestVO requestVO) {
        AssertUtil.notNull(requestVO.getTemplateType(), "templateType\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge(MsgTemplateTypeEnum.getByCode((String)requestVO.getTemplateType()) != null, "templateType\u4e0d\u5b58\u5728");
        return this.msgWeChatMiniProTemplateService.listPlaceholderRel(requestVO);
    }

    public ResponseData<MsgWxMiniProTempUpdateStatusResponseVO> updateStatus(@RequestBody MsgWxMiniProTempUpdateStatusRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((Object)requestVO.getOpenStatus(), "openStatus\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull(requestVO.getMsgWxMiniProTempCode(), "msgWxMiniProTempCode\u4e0d\u80fd\u4e3a\u7a7a");
        return this.msgWeChatMiniProTemplateService.updateStatus(requestVO);
    }

    public ResponseData<MsgWxMiniProTempUpdateResponseVO> addOrUpdateTemplate(@RequestBody MsgWxMiniProTempUpdateRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.judge(ObjectUtils.allNotNull((Object[])new Object[]{requestVO.getWxTempId(), requestVO.getWxTempText(), requestVO.getWxTempText(), requestVO.getWxTempType()}), "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6a21\u677f\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull(requestVO.getUrl(), "\u8df3\u8f6c\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull(requestVO.getTemplateType(), "\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge(MsgTemplateTypeEnum.getByCode((String)requestVO.getTemplateType()) != null, "\u6a21\u677f\u7c7b\u578b\u4e0d\u5b58\u5728");
        AssertUtil.notEmpty(requestVO.getFieldList(), "\u5173\u8054\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        return this.msgWeChatMiniProTemplateService.addOrUpdateTemplate(requestVO);
    }

    public ResponseData<MsgWxMiniProTempDetailResponseVO> detailByCode(MsgWxMiniProTempDetailRequestVO requestVO) {
        AssertUtil.notNull(requestVO.getMsgWxMiniProTempCode(), "msgWxMiniProTempCode\u4e0d\u80fd\u4e3a\u7a7a");
        return this.msgWeChatMiniProTemplateService.detailByCode(requestVO.getMsgWxMiniProTempCode());
    }

    public ResponseData<MsgWxMiniProTempDetailResponseVO> detailByTemplateType(MsgWxMiniProTempDetailRequestVO requestVO) {
        AssertUtil.notNull(requestVO.getTemplateType(), "templateType\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge(MsgTemplateTypeEnum.getByCode((String)requestVO.getTemplateType()) != null, "templateType\u4e0d\u5b58\u5728");
        return this.msgWeChatMiniProTemplateService.detailByTemplateType(requestVO.getTemplateType());
    }

    public MsgWeChatMiniProTemplateController(MsgWeChatMiniProTemplateService msgWeChatMiniProTemplateService) {
        this.msgWeChatMiniProTemplateService = msgWeChatMiniProTemplateService;
    }
}

