/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.controller;

import com.bizvane.message.api.service.MsgSendTimeService;
import com.bizvane.message.api.util.AssertUtil;
import com.bizvane.message.feign.api.MsgSendTimeFeign;
import com.bizvane.message.feign.vo.OptUserVO;
import com.bizvane.message.feign.vo.sendtime.SendTimeAddRequestVO;
import com.bizvane.message.feign.vo.sendtime.SendTimeAddResponseVO;
import com.bizvane.message.feign.vo.sendtime.SendTimeDetailResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sendTime"})
public class MsgSendTimeController
implements MsgSendTimeFeign {
    private final MsgSendTimeService msgSendTimeService;

    public ResponseData<SendTimeDetailResponseVO> detail() {
        return this.msgSendTimeService.detail();
    }

    public ResponseData<SendTimeAddResponseVO> addOrUpdate(@RequestBody SendTimeAddRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.judge(ObjectUtils.allNotNull((Object[])new Object[]{requestVO.getSendTimeStart(), requestVO.getSendTimeEnd()}), "\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge(requestVO.getSendTimeStart().isBefore(requestVO.getSendTimeEnd()), "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        return this.msgSendTimeService.addOrUpdate(requestVO);
    }

    public MsgSendTimeController(MsgSendTimeService msgSendTimeService) {
        this.msgSendTimeService = msgSendTimeService;
    }
}

