/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.message.api.service.MsgWxMiniProTempSceneService;
import com.bizvane.message.api.util.ConvertUtil;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempScenePO;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempSceneRelPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempTemplateTypePO;
import com.bizvane.message.domain.service.IMsgWxMiniProTempSceneConfigService;
import com.bizvane.message.domain.service.IMsgWxMiniProTempSceneRelService;
import com.bizvane.message.domain.service.IMsgWxMiniProTempSceneService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.domain.util.UID;
import com.bizvane.message.feign.vo.tempscene.MsgWxMiniProTempSceneDetailRequestVO;
import com.bizvane.message.feign.vo.tempscene.MsgWxMiniProTempSceneDetailResponseVO;
import com.bizvane.message.feign.vo.tempscene.MsgWxMiniProTempSceneUpdateRequestVO;
import com.bizvane.message.feign.vo.tempscene.MsgWxMiniProTempSceneUpdateResponseVO;
import com.bizvane.message.feign.vo.tempscene.MsgWxMiniProTempSceneUpdateStatusRequestVO;
import com.bizvane.message.feign.vo.tempscene.MsgWxMiniProTempSceneUpdateStatusResponseVO;
import com.bizvane.message.feign.vo.tempscene.MsgWxMiniProTempTemplateTypeVO;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class MsgWxMiniProTempSceneBusinessImpl
implements MsgWxMiniProTempSceneService {
    private final IMsgWxMiniProTempSceneService msgWxMiniProTempSceneService;
    private final IMsgWxMiniProTempSceneRelService msgWxMiniProTempSceneRelService;
    private final IMsgWxMiniProTempSceneConfigService msgWxMiniProTempSceneConfigService;

    @Override
    public ResponseData<List<MsgWxMiniProTempSceneDetailResponseVO>> listAll() {
        LinkedList<MsgWxMiniProTempSceneDetailResponseVO> reslutList = new LinkedList<MsgWxMiniProTempSceneDetailResponseVO>();
        List scenePOList = this.msgWxMiniProTempSceneService.list();
        if (CollectionUtils.isEmpty((Collection)scenePOList)) {
            return ResponseUtil.success(reslutList);
        }
        for (MsgWxMiniProTempScenePO proTempScenePO : scenePOList) {
            MsgWxMiniProTempSceneDetailResponseVO msgWxMiniProTempSceneVO = ConvertUtil.convertMsgWxMiniProTempScenePO2VO(proTempScenePO);
            List<MsgWxMiniProTempTemplateTypeVO> templateTypeVOS = this.getMsgWxMiniProTempTemplateTypeVOS(msgWxMiniProTempSceneVO.getMsgWxMiniProTempSceneCode());
            msgWxMiniProTempSceneVO.setTemplateTypeVOS(templateTypeVOS);
            reslutList.add(msgWxMiniProTempSceneVO);
        }
        return ResponseUtil.success(reslutList);
    }

    @Override
    public ResponseData<MsgWxMiniProTempSceneDetailResponseVO> detail(MsgWxMiniProTempSceneDetailRequestVO requestVO) {
        String sceneCode = requestVO.getMsgWxMiniProTempSceneCode();
        MsgWxMiniProTempScenePO proTempScenePO = this.msgWxMiniProTempSceneService.selectOneByCode(sceneCode);
        if (proTempScenePO == null) {
            return ResponseUtil.success((Object)new MsgWxMiniProTempSceneDetailResponseVO());
        }
        MsgWxMiniProTempSceneDetailResponseVO msgWxMiniProTempSceneVO = ConvertUtil.convertMsgWxMiniProTempScenePO2VO(proTempScenePO);
        List<MsgWxMiniProTempTemplateTypeVO> msgWxMiniProTempTemplateTypeVOS = this.getMsgWxMiniProTempTemplateTypeVOS(msgWxMiniProTempSceneVO.getMsgWxMiniProTempSceneCode());
        msgWxMiniProTempSceneVO.setTemplateTypeVOS(msgWxMiniProTempTemplateTypeVOS);
        return ResponseUtil.success((Object)msgWxMiniProTempSceneVO);
    }

    @Override
    public ResponseData<List<MsgWxMiniProTempTemplateTypeVO>> listTemplateType(MsgWxMiniProTempSceneDetailRequestVO requestVO) {
        List<MsgWxMiniProTempTemplateTypeVO> msgWxMiniProTempTemplateTypeVOS = this.getMsgWxMiniProTempTemplateTypeVOS(requestVO.getMsgWxMiniProTempSceneCode());
        return ResponseUtil.success(msgWxMiniProTempTemplateTypeVOS);
    }

    @Override
    public ResponseData<List<MsgWxMiniProTempTemplateTypeVO>> configListTemplateType(MsgWxMiniProTempSceneDetailRequestVO requestVO) {
        List proTempTemplateTypePOS = this.msgWxMiniProTempSceneConfigService.findTemplateTypeListByWxMiniProTempSceneCode(requestVO.getMsgWxMiniProTempSceneCode());
        LinkedList<MsgWxMiniProTempTemplateTypeVO> templateTypeVOS = new LinkedList<MsgWxMiniProTempTemplateTypeVO>();
        if (CollectionUtils.isNotEmpty((Collection)proTempTemplateTypePOS)) {
            for (MsgWxMiniProTempTemplateTypePO msgWxMiniProTempTemplateTypePO : proTempTemplateTypePOS) {
                templateTypeVOS.add(ConvertUtil.convertMsgWxMiniProTempTemplateTypePO2VO(msgWxMiniProTempTemplateTypePO));
            }
        }
        return ResponseUtil.success(templateTypeVOS);
    }

    @Override
    public ResponseData<MsgWxMiniProTempSceneUpdateResponseVO> addOrUpdate(MsgWxMiniProTempSceneUpdateRequestVO requestVO) {
        LambdaUpdateWrapper sceneUpdateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(MsgWxMiniProTempScenePO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(MsgWxMiniProTempScenePO::getModifiedUserName, (Object)requestVO.getOptUserName())).set(MsgWxMiniProTempScenePO::getOpenJudge, (Object)requestVO.getOpenJudge())).eq(MsgWxMiniProTempScenePO::getMsgWxMiniProTempSceneCode, (Object)requestVO.getMsgWxMiniProTempSceneCode());
        boolean update = this.msgWxMiniProTempSceneService.update((Wrapper)sceneUpdateWrapper);
        if (update) {
            List templateTypeCodeList = requestVO.getTemplateTypeCodeList();
            LambdaUpdateWrapper sceneRelDeleteWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(MsgWxMiniProTempSceneRelPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(MsgWxMiniProTempSceneRelPO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(MsgWxMiniProTempSceneRelPO::getMsgWxMiniProTempSceneCode, (Object)requestVO.getMsgWxMiniProTempSceneCode());
            boolean remove = this.msgWxMiniProTempSceneRelService.remove((Wrapper)sceneRelDeleteWrapper);
            if (CollectionUtils.isNotEmpty((Collection)templateTypeCodeList)) {
                List miniProTempSceneRelPOS = templateTypeCodeList.stream().map(templateTypeCode -> {
                    MsgWxMiniProTempSceneRelPO msgWxMiniProTempSceneRelPO = new MsgWxMiniProTempSceneRelPO();
                    msgWxMiniProTempSceneRelPO.setMsgWxMiniProTempSceneRelCode(UID.getUid());
                    msgWxMiniProTempSceneRelPO.setMsgWxMiniProTempTemplateTypeCode(templateTypeCode);
                    msgWxMiniProTempSceneRelPO.setMsgWxMiniProTempSceneCode(requestVO.getMsgWxMiniProTempSceneCode());
                    msgWxMiniProTempSceneRelPO.setCreateUserCode(requestVO.getOptUserCode());
                    msgWxMiniProTempSceneRelPO.setCreateUserName(requestVO.getOptUserName());
                    return msgWxMiniProTempSceneRelPO;
                }).collect(Collectors.toList());
                boolean bl = this.msgWxMiniProTempSceneRelService.saveBatch(miniProTempSceneRelPOS);
            }
        }
        MsgWxMiniProTempSceneUpdateResponseVO responseVO = new MsgWxMiniProTempSceneUpdateResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    @Override
    public ResponseData<MsgWxMiniProTempSceneUpdateStatusResponseVO> updateStatus(MsgWxMiniProTempSceneUpdateStatusRequestVO requestVO) {
        LambdaUpdateWrapper sceneUpdateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(MsgWxMiniProTempScenePO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(MsgWxMiniProTempScenePO::getModifiedUserName, (Object)requestVO.getOptUserName())).set(MsgWxMiniProTempScenePO::getOpenJudge, (Object)requestVO.getOpenJudge())).eq(MsgWxMiniProTempScenePO::getMsgWxMiniProTempSceneCode, (Object)requestVO.getMsgWxMiniProTempSceneCode());
        boolean update = this.msgWxMiniProTempSceneService.update((Wrapper)sceneUpdateWrapper);
        MsgWxMiniProTempSceneUpdateStatusResponseVO responseVO = new MsgWxMiniProTempSceneUpdateStatusResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    private List<MsgWxMiniProTempTemplateTypeVO> getMsgWxMiniProTempTemplateTypeVOS(String msgWxMiniProTempSceneCode) {
        List templateTypeList = this.msgWxMiniProTempSceneRelService.findTemplateTypeListByWxMiniProTempSceneCode(msgWxMiniProTempSceneCode);
        LinkedList<MsgWxMiniProTempTemplateTypeVO> templateTypeVOS = new LinkedList<MsgWxMiniProTempTemplateTypeVO>();
        if (CollectionUtils.isNotEmpty((Collection)templateTypeList)) {
            for (MsgWxMiniProTempTemplateTypePO msgWxMiniProTempTemplateTypePO : templateTypeList) {
                templateTypeVOS.add(ConvertUtil.convertMsgWxMiniProTempTemplateTypePO2VO(msgWxMiniProTempTemplateTypePO));
            }
        }
        return templateTypeVOS;
    }

    public MsgWxMiniProTempSceneBusinessImpl(IMsgWxMiniProTempSceneService msgWxMiniProTempSceneService, IMsgWxMiniProTempSceneRelService msgWxMiniProTempSceneRelService, IMsgWxMiniProTempSceneConfigService msgWxMiniProTempSceneConfigService) {
        this.msgWxMiniProTempSceneService = msgWxMiniProTempSceneService;
        this.msgWxMiniProTempSceneRelService = msgWxMiniProTempSceneRelService;
        this.msgWxMiniProTempSceneConfigService = msgWxMiniProTempSceneConfigService;
    }
}

