/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.bizvane.message.api.model.dto.config.OptUserDTO;
import com.bizvane.message.api.model.vo.template.wxmini.MsgWechatMiniProSceneConfigEditRequestParam;
import com.bizvane.message.api.model.vo.template.wxmini.MsgWechatMiniProSceneConfigQueryRequestParam;
import com.bizvane.message.api.model.vo.template.wxmini.MsgWechatMiniProSceneConfigVO;
import com.bizvane.message.api.model.vo.template.wxmini.MsgWechatMiniProSceneEditRequestParam;
import com.bizvane.message.api.model.vo.template.wxmini.MsgWechatMiniProTemplateTypeVO;
import com.bizvane.message.api.service.MsgWechatMiniProSceneConfigService;
import com.bizvane.message.api.service.OptUserService;
import com.bizvane.message.api.util.AssertUtil;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempSceneConfigPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempScenePO;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempSceneRelPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempTemplateTypePO;
import com.bizvane.message.domain.service.IMsgWxMiniProTempSceneConfigService;
import com.bizvane.message.domain.service.IMsgWxMiniProTempSceneRelService;
import com.bizvane.message.domain.service.IMsgWxMiniProTempSceneService;
import com.bizvane.message.domain.service.IMsgWxMiniProTempTemplateTypeService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.domain.util.UID;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class MsgWechatMiniProSceneConfigServiceImpl
implements MsgWechatMiniProSceneConfigService {
    private final OptUserService optUserService;
    private final IMsgWxMiniProTempSceneService msgWxMiniProTempSceneService;
    private final IMsgWxMiniProTempSceneRelService msgWxMiniProTempSceneRelService;
    private final IMsgWxMiniProTempTemplateTypeService msgWxMiniProTempTemplateTypeService;
    private final IMsgWxMiniProTempSceneConfigService msgWxMiniProTempSceneConfigService;

    @Override
    public ResponseData<List<MsgWechatMiniProSceneConfigVO>> getSceneConfigList() {
        List scenePOList = this.msgWxMiniProTempSceneService.list();
        if (CollectionUtils.isEmpty((Collection)scenePOList)) {
            return ResponseUtil.success(new ArrayList());
        }
        List<MsgWxMiniProTempSceneRelPO> sceneRelPOList = this.getMsgWxMiniProTempSceneRelPOS(scenePOList);
        List<MsgWxMiniProTempTemplateTypePO> templateTypePOList = this.getMsgWxMiniProTempTemplateTypePOS(sceneRelPOList);
        List<MsgWechatMiniProSceneConfigVO> result = MsgWechatMiniProSceneConfigServiceImpl.mergeGetSceneConfigVOList(scenePOList, sceneRelPOList, templateTypePOList);
        return ResponseUtil.success(result);
    }

    @Override
    public ResponseData<List<MsgWechatMiniProTemplateTypeVO>> getSceneTemplateTypeList(MsgWechatMiniProSceneConfigQueryRequestParam requestParam) {
        AssertUtil.notNull(requestParam.getMsgWxMiniProTempSceneCode());
        List sceneConfigPOList = this.msgWxMiniProTempSceneConfigService.findByMsgWxMiniProTempSceneCode(requestParam.getMsgWxMiniProTempSceneCode());
        if (CollectionUtils.isEmpty((Collection)sceneConfigPOList)) {
            return ResponseUtil.success(new ArrayList());
        }
        List<String> msgWxMiniProTempTemplateTypeCodeList = sceneConfigPOList.stream().map(MsgWxMiniProTempSceneConfigPO::getMsgWxMiniProTempTemplateTypeCode).collect(Collectors.toList());
        List<MsgWxMiniProTempTemplateTypePO> templateTypePOList = this.getWxMiniProTempTemplateTypePOS(msgWxMiniProTempTemplateTypeCodeList);
        List templateTypeVOS = templateTypePOList.stream().map(msgWxMiniProTempTemplateTypePO -> {
            MsgWechatMiniProTemplateTypeVO msgWechatMiniProTemplateTypeVO = new MsgWechatMiniProTemplateTypeVO();
            BeanUtils.copyProperties((Object)msgWxMiniProTempTemplateTypePO, (Object)msgWechatMiniProTemplateTypeVO);
            return msgWechatMiniProTemplateTypeVO;
        }).collect(Collectors.toList());
        return ResponseUtil.success(templateTypeVOS);
    }

    @Override
    public ResponseData<Boolean> updateSceneOpenJudge(MsgWechatMiniProSceneConfigEditRequestParam requestParam) {
        AssertUtil.notNull(requestParam.getMsgWxMiniProTempSceneCode(), requestParam.getOpenJudge());
        OptUserDTO optUser = this.optUserService.getOptUser();
        Boolean result = this.updateScene(requestParam.getOpenJudge(), requestParam.getMsgWxMiniProTempSceneCode(), optUser);
        return ResponseUtil.success((Object)result);
    }

    private Boolean updateScene(Boolean openJudge, String msgWxMiniProTempSceneCode, OptUserDTO optUser) {
        MsgWxMiniProTempScenePO msgWxMiniProTempScenePO = new MsgWxMiniProTempScenePO();
        msgWxMiniProTempScenePO.setOpenJudge(openJudge);
        msgWxMiniProTempScenePO.setMsgWxMiniProTempSceneCode(msgWxMiniProTempSceneCode);
        msgWxMiniProTempScenePO.setModifiedUserName(optUser.getOptUserName());
        msgWxMiniProTempScenePO.setModifiedUserCode(optUser.getOptUserCode());
        Boolean result = this.msgWxMiniProTempSceneService.updateOne(msgWxMiniProTempScenePO);
        return result;
    }

    @Override
    public ResponseData<Boolean> saveOrUpdateScene(MsgWechatMiniProSceneEditRequestParam requestParam) {
        AssertUtil.notNull(requestParam.getMsgWxMiniProTempSceneCode(), requestParam.getOpenJudge());
        AssertUtil.notEmpty(requestParam.getTemplateCodeList());
        MsgWxMiniProTempScenePO proTempScenePO = this.msgWxMiniProTempSceneService.selectOneByCode(requestParam.getMsgWxMiniProTempSceneCode());
        AssertUtil.notNull((Object)proTempScenePO);
        OptUserDTO optUser = this.optUserService.getOptUser();
        this.updateScene(requestParam.getOpenJudge(), requestParam.getMsgWxMiniProTempSceneCode(), optUser);
        this.deleteSceneRelHistory(requestParam, optUser);
        boolean result = this.saveSceneRelBatch(requestParam, optUser);
        return ResponseUtil.success((Object)result);
    }

    private boolean saveSceneRelBatch(MsgWechatMiniProSceneEditRequestParam requestParam, OptUserDTO optUser) {
        List sceneRelPOS = requestParam.getTemplateCodeList().stream().map(e -> {
            MsgWxMiniProTempSceneRelPO msgWxMiniProTempSceneRelPO = new MsgWxMiniProTempSceneRelPO();
            msgWxMiniProTempSceneRelPO.setMsgWxMiniProTempTemplateTypeCode(e);
            msgWxMiniProTempSceneRelPO.setMsgWxMiniProTempSceneCode(requestParam.getMsgWxMiniProTempSceneCode());
            msgWxMiniProTempSceneRelPO.setCreateUserName(optUser.getOptUserName());
            msgWxMiniProTempSceneRelPO.setCreateUserCode(optUser.getOptUserCode());
            msgWxMiniProTempSceneRelPO.setMsgWxMiniProTempSceneRelCode(UID.getUid());
            return msgWxMiniProTempSceneRelPO;
        }).collect(Collectors.toList());
        boolean result = this.msgWxMiniProTempSceneRelService.saveBatch(sceneRelPOS);
        return result;
    }

    private boolean deleteSceneRelHistory(MsgWechatMiniProSceneEditRequestParam requestParam, OptUserDTO optUser) {
        MsgWxMiniProTempSceneRelPO msgWxMiniProTempSceneRelPO = new MsgWxMiniProTempSceneRelPO();
        msgWxMiniProTempSceneRelPO.setMsgWxMiniProTempSceneCode(requestParam.getMsgWxMiniProTempSceneCode());
        msgWxMiniProTempSceneRelPO.setModifiedUserCode(optUser.getOptUserCode());
        msgWxMiniProTempSceneRelPO.setModifiedUserName(optUser.getOptUserName());
        Boolean result = this.msgWxMiniProTempSceneRelService.deleteByCode(msgWxMiniProTempSceneRelPO);
        return result;
    }

    private static List<MsgWechatMiniProSceneConfigVO> mergeGetSceneConfigVOList(List<MsgWxMiniProTempScenePO> scenePOList, List<MsgWxMiniProTempSceneRelPO> sceneRelPOList, List<MsgWxMiniProTempTemplateTypePO> templateTypePOList) {
        List<MsgWechatMiniProSceneConfigVO> result = scenePOList.stream().map(msgWxMiniProTempScenePO -> {
            MsgWechatMiniProSceneConfigVO msgWechatMiniProSceneConfigVO = new MsgWechatMiniProSceneConfigVO();
            BeanUtils.copyProperties((Object)msgWxMiniProTempScenePO, (Object)msgWechatMiniProSceneConfigVO);
            List templateTypeCodeList = sceneRelPOList.stream().filter(relPO -> Objects.equals(relPO.getMsgWxMiniProTempSceneCode(), msgWxMiniProTempScenePO.getMsgWxMiniProTempSceneCode())).map(MsgWxMiniProTempSceneRelPO::getMsgWxMiniProTempTemplateTypeCode).collect(Collectors.toList());
            List<MsgWechatMiniProTemplateTypeVO> templateTypeVOS = templateTypePOList.stream().filter(msgWxMiniProTempTemplateTypePO -> templateTypeCodeList.contains(msgWxMiniProTempTemplateTypePO.getMsgWxMiniProTempTemplateTypeCode())).map(msgWxMiniProTempTemplateTypePO -> {
                MsgWechatMiniProTemplateTypeVO msgWechatMiniProTemplateTypeVO = new MsgWechatMiniProTemplateTypeVO();
                BeanUtils.copyProperties((Object)msgWxMiniProTempTemplateTypePO, (Object)msgWechatMiniProTemplateTypeVO);
                return msgWechatMiniProTemplateTypeVO;
            }).collect(Collectors.toList());
            msgWechatMiniProSceneConfigVO.setTemplateTypeList(templateTypeVOS);
            return msgWechatMiniProSceneConfigVO;
        }).collect(Collectors.toList());
        return result;
    }

    public static void main(String[] args) {
        ArrayList msgWxMiniProTempSceneRelPOS = new ArrayList();
        List collect = msgWxMiniProTempSceneRelPOS.stream().filter(relPO -> Objects.equals(relPO.getMsgWxMiniProTempSceneCode(), "1122")).collect(Collectors.toList());
        System.out.println("111:" + collect);
    }

    private List<MsgWxMiniProTempTemplateTypePO> getMsgWxMiniProTempTemplateTypePOS(List<MsgWxMiniProTempSceneRelPO> sceneRelPOList) {
        if (CollectionUtils.isEmpty(sceneRelPOList)) {
            return new ArrayList<MsgWxMiniProTempTemplateTypePO>();
        }
        List<String> msgWxMiniProTempTemplateTypeCodeList = sceneRelPOList.stream().map(MsgWxMiniProTempSceneRelPO::getMsgWxMiniProTempTemplateTypeCode).distinct().collect(Collectors.toList());
        return this.getWxMiniProTempTemplateTypePOS(msgWxMiniProTempTemplateTypeCodeList);
    }

    private List<MsgWxMiniProTempTemplateTypePO> getWxMiniProTempTemplateTypePOS(List<String> msgWxMiniProTempTemplateTypeCodeList) {
        List templateTypePOList = this.msgWxMiniProTempTemplateTypeService.findByWxMiniProTempTemplateTypeCodeList(msgWxMiniProTempTemplateTypeCodeList);
        return templateTypePOList;
    }

    private List<MsgWxMiniProTempSceneRelPO> getMsgWxMiniProTempSceneRelPOS(List<MsgWxMiniProTempScenePO> scenePOList) {
        if (CollectionUtils.isEmpty(scenePOList)) {
            return new ArrayList<MsgWxMiniProTempSceneRelPO>();
        }
        List msgWxMiniProTempSceneCodeList = scenePOList.stream().map(MsgWxMiniProTempScenePO::getMsgWxMiniProTempSceneCode).collect(Collectors.toList());
        List sceneRelPOList = this.msgWxMiniProTempSceneRelService.findByWxMiniProTempSceneCodes(msgWxMiniProTempSceneCodeList);
        return sceneRelPOList;
    }

    public MsgWechatMiniProSceneConfigServiceImpl(OptUserService optUserService, IMsgWxMiniProTempSceneService msgWxMiniProTempSceneService, IMsgWxMiniProTempSceneRelService msgWxMiniProTempSceneRelService, IMsgWxMiniProTempTemplateTypeService msgWxMiniProTempTemplateTypeService, IMsgWxMiniProTempSceneConfigService msgWxMiniProTempSceneConfigService) {
        this.optUserService = optUserService;
        this.msgWxMiniProTempSceneService = msgWxMiniProTempSceneService;
        this.msgWxMiniProTempSceneRelService = msgWxMiniProTempSceneRelService;
        this.msgWxMiniProTempTemplateTypeService = msgWxMiniProTempTemplateTypeService;
        this.msgWxMiniProTempSceneConfigService = msgWxMiniProTempSceneConfigService;
    }
}

